/////////////////////////////////////////////////////////////
// CINEMA SDK : CINEMA OPERATING SYSTEM        						 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D V8      												 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

// interface functions

#ifndef __OPERATINGSYSTEM_H
#define __OPERATINGSYSTEM_H

#include "ge_math.h"
#include "ge_vector.h"
#include "ge_prepass.h"
#include "c4d_basetime.h"

class  Atom;
class  AtomArray;
class  NodeData;
class  GeListNode;
class  GeListHead;
class  RootTextureString;
class  AliasTrans;
class  Registry;
class  CDialog;
class  CUserArea;
class  _GeListView;
class  _SimpleListView;
class  BaseTag;
class  MPBaseThread;
class  Semaphore;
class  VariableTag;
class  BaseTime;
class	 BaseChannel;
class	 BaseContainer;
class	 BaseDocument;
class	 BaseSelect;
class  HyperFile;
class  BaseList2D;
class  BaseList4D;
class  BaseObject;
class  SplineObject;
class  PluginShader;
class  PointObject;
class  PolygonObject;
class  LineObject;
class  PluginObject;
class  BaseDraw;
class  BaseDrawHelp;
class  BaseView;
class  BaseTrack;
class  BaseLink;
class  String;
class  BaseBitmap;
class  MemoryPool;
class  BaseMaterial;
class  Material;
class  PluginMaterial;
class  PluginVideoPost;
class	 RenderData;
class  Render;
class	 TextureTag;
class  MovieSaver;
class  BrowseFiles;
class  Parser;
class  BaseFile;
class  SelectionTag;
class  PluginTag;
class  LassoSelection;
class  UVWTag;
class  ObjectSafety;
class  ParticleObject;
class  PluginObject;
class  PluginSceneHook;
class  ParticleTag;
class  StickTextureTag;
class  Particle;
class  LocalResource;
class  HierarchyHelp;
class  BaseKey;
class  BaseSequence;
class  BaseTrack;
class  PLAKey;
class  FolderSequence;
class  SoundSequence;
class  BaseSound;
class	 BaseThread;
class  EnumerateEdges;
class  PaintTexture;
class  UVClass;
class  EditorWindow;
class  VPBuffer;
class  PluginKey;
class  PluginSequence;
class  PluginTrack;
class  GeData;
class  Description;
class  DescID;
class  DynamicDescription;
class  Description;
class  DescID;
class  _TextureGroup;
class  BaseContainer;
class  Filename;
class  VideoPostData;
class  BasePlugin;
class  PriorityList;
class  LensGlowStruct;
class  CBaseFrame;
class  RayFilter;
struct CustomDataType;
struct C4D_Painter;
struct C4D_BitmapFilter;
struct ParticleDetails;
struct PolyInfo;
struct SData;
struct VolumeData;
struct Ray;
struct Tangent;
struct UVWStruct;
struct Segment;
struct Polygon;
struct TimingStruct;
struct LVector;
struct LMatrix;
struct InitRenderStruct;
struct RayObject;
struct RayLight;
struct PolyVector;
struct TexData;
struct VideoPostStruct;
struct SurfaceData;
struct PMStruct;
struct VIDEOPOST;
struct CHANNELSHADER;
struct VOLUMESHADER;
struct VP_DATA;
struct MouseDownInfo;
struct DrawInfo;
struct RayLightCache;
struct IconData;
struct C4D_GraphView;
struct NODEPLUGIN;
struct VPFragment;
struct BranchInfo;
struct AnimValue;
struct ObjectColorProperties;
struct PixelFragment;
struct ChannelData;
struct CUSTOMDATATYPEPLUGIN;
struct RESOURCEDATATYPEPLUGIN;
struct TempUVHandle;

#define API_VERSION	8200

#define C4DPL_SHADER						 2
#define C4DPL_MATERIAL					 3
#define C4DPL_COFFEEMESSAGE			 4
#define C4DPL_COMMAND						 7
#define C4DPL_OBJECT						 8
#define C4DPL_TAG								10
#define C4DPL_BITMAPFILTER			12
#define C4DPL_VIDEOPOST					13
#define C4DPL_TOOL							14
#define C4DPL_SCENEHOOK					15
#define C4DPL_NODE							16
#define C4DPL_LIBRARY						18
#define C4DPL_KEY								19
#define C4DPL_SEQUENCE					20
#define C4DPL_TRACK							21
#define C4DPL_BITMAPLOADER			22
#define C4DPL_BITMAPSAVER				23
#define C4DPL_SCENELOADER				24
#define C4DPL_SCENESAVER				25
#define C4DPL_COREMESSAGE				26
#define C4DPL_CUSTOMGUI					27
#define C4DPL_CUSTOMDATATYPE		28
#define C4DPL_RESOURCEDATATYPE	29

enum
{
	DIALOG_PIN = 1,						// LONG flags
	DIALOG_CHECKBOX,					// LONG id, LONG flags, String *name
	DIALOG_STATICTEXT,				// LONG id, LONG flags, String *name, LONG borderstyle
	DIALOG_BUTTON,						// LONG id, LONG flags, String *name
	DIALOG_ARROWBUTTON,				// LONG id, LONG flags, LONG arrowtype
	DIALOG_EDITTEXT,					// LONG id, LONG flags
	DIALOG_EDITNUMBER,				// LONG id, LONG flags
	DIALOG_EDITNUMBERUD,			// LONG id, LONG flags
	DIALOG_EDITSLIDER,				// LONG id, LONG flags
	DIALOG_SLIDER,						// LONG id, LONG flags
	DIALOG_COLORFIELD,				// LONG id, LONG flags
	DIALOG_COLORCHOOSER,			// LONG id, LONG flags
	DIALOG_USERAREA,					// LONG id, LONG flags
	DIALOG_RADIOGROUP,				// LONG id, LONG flags
	DIALOG_COMBOBOX,					// LONG id, LONG flags
	DIALOG_POPUPBUTTON,				// LONG id, LONG flags
	DIALOG_CHILD,							// LONG id, LONG subid, String *child);
	DIALOG_FREECHILDS,				// LONG id
	DIALOG_DLGGROUP,					// LONG flags
	DIALOG_SETTITLE,					// String *name
	DIALOG_GROUPSPACE,				// spacex,spacey
	DIALOG_GROUPBORDER,				// borderstyle
	DIALOG_GROUPBORDERSIZE,	  // left, top, right, bottom
	DIALOG_SETIDS,						// left, top, right, bottom
	DIALOG_LAYOUTCHANGED,			// relayout dialog
	DIALOG_ACTIVATE,					// activate gadget
	DIALOG_ADDSUBMENU,				// add submenu, text
	DIALOG_ENDSUBMENU,				// add submenu, text
	DIALOG_ADDMENUCMD,				// add menutext, text, cmdid
	DIALOG_FLUSHMENU,					// delete all menu entries
	DIALOG_INIT,							// create new layout
	DIALOG_CHECKNUMBERS,			// range check of all dialog elements
	DIALOG_SETGROUP,					// set group as insert group
	DIALOG_FLUSHGROUP,				// flush all elements of this group and set insert point to this group
	DIALOG_SETMENU,						// set and display menu in manager
	DIALOG_SCREEN2LOCALX,			// Screen2Local coordinates
	DIALOG_SCREEN2LOCALY,			// Screen2Local coordinates
	DIALOG_ADDMENUSTR,				// add menutext, text, id
	DIALOG_RADIOBUTTON,				// LONG id, LONG flags, String *name
	DIALOG_ADDMENUSEP,				// add menu separator
	DIALOG_SEPARATOR,					// add separator
	DIALOG_MULTILINEEDITTEXT, // add multiline editfield
	DIALOG_INITMENUSTR,				// enable/disable/check/uncheck menustrings
	DIALOG_RADIOTEXT,
	DIALOG_MENURESOURCE,			// private for painter
	DIALOG_LISTVIEW,					// LONG id, LONG flags
	DIALOG_SUBDIALOG,					// LONG id, LONG flags
	DIALOG_CHECKCLOSE,				// CheckCloseMessage for dialog
	DIALOG_GETTRISTATE,				// get TriState-flag of the specified gadget
	DIALOG_SDK,								// LONG id, LONG flags, String *name
	DIALOG_SCROLLGROUP,				// create ScrollGroup
	DIALOG_ISOPEN,						// returns TRUE if the dialog is open
	DIALOG_REMOVEGADGET,			// removes an element from the layout

	DIALOG_
};

enum
{
	LV_GETLINECOUNT    = 1,  // request the number of lines of the listview
	LV_GETCOLUMNCOUNT  = 2,  // request the number of columns of listview
	LV_GETLINEHEIGHT   = 3,  // ask for the line height of the specific 'line'
	LV_GETCOLUMNWIDTH  = 4,  // ask for the width of the specific 'column' in 'line'
	LV_GETCOLUMTYPE    = 5,  // ask for the type of the column in 'line',
		LV_COLUMN_TEXT     = 'txt',
		LV_COLUMN_EDITTEXT = 'edt',
		LV_COLUMN_BMP      = 'bmp',
		LV_COLUMN_CHECKBOX = 'chk',
		LV_COLUMN_BUTTON   = 'btn',
		LV_COLUMN_USERDRAW = 'usr',
		LV_COLUMN_COLORVIEW= 'clv',

	LV_GETCOLUMDATA    = 6,  // ask for the data of the column in 'line',
	LV_GETLINESELECTED = 7,  // ask if the line is selected
	LV_GETCOLSPACE     = 8,  // ask for space in pixels between two columns
	LV_GETLINESPACE    = 9,  // ask for space in pixels between two lines
	LV_GETFIXEDLAYOUT  = 10, // ask for fixed layout: FALSE...indiv. layout, TRUE...fixed layout
	LV_DESTROYLISTVIEW = 11, // destroy listview and all data
	LV_INITCACHE       = 12, // (internal) before call the listview

	LV_LMOUSEDOWN       = 50, // mouse down at line, col,
	LV_ACTION						= 51, // gadget command, col, data1 = msg,
	LV_USERDRAW					= 52,
	LV_REDRAW						= 53, // redraw the listview (supermessage)
	LV_DATACHANGED		  = 54, // layout data has changed
	LV_SHOWLINE					= 55, // scroll line into the visible area
	LV_DRAGRECEIVE			= 56,	// drag receive

	LV_SIMPLE_SELECTIONCHANGED = 100, // simplelistview: selection changed
	LV_SIMPLE_CHECKBOXCHANGED  = 101, // simplelistview: checkbox changed
	LV_SIMPLE_FOCUSITEM        = 102, // simplelistview: set focus to item
	LV_SIMPLE_BUTTONCLICK      = 103, // simplelistview: button click
		LV_SIMPLE_ITEM_ID	= 1,
		LV_SIMPLE_COL_ID	= 2,
		LV_SIMPLE_DATA    = 3,
	LV_SIMPLE_DOUBLECLICK      = 104, // doubleclick occured

	// result types
	LV_RES_LONG        = 'long',
	LV_RES_BITMAP      = 'bmp',
	LV_RES_STRING      = 'strg',
	LV_RES_VECTOR      = 'vec',
	LV_RES_NIL         = 'nil',

	LV__
};

// predefined calling points for tags and scenehooks
#define	EXECUTION_INITIAL							1000
#define EXECUTION_ANIMATION						2000
#define EXECUTION_EXPRESSION				  3000
#define EXECUTION_DYNAMICS						4000
#define EXECUTION_GENERATOR					  5000

#define EXECUTION_RESULT_OK						0
#define EXECUTION_RESULT_USERBREAK		1
#define EXECUTION_RESULT_MEMORYERROR	2

enum
{
	DLG_OK     = 1,
	DLG_CANCEL = 2,
	DLG_HELP   = 4,
	DLG_
};

enum StringEncoding
{
	StXbit		= 0,
	St8bit		= 1,
	St7bit		= 2,
	St7bithex	= 3
};

#define MODELINGCOMMANDFLAG_CREATEUNDO	(1<<0)

struct ModelingCommandData
{	
	ModelingCommandData() { doc=NULL; op=NULL; bc=NULL; mode=0; flags=0; result1=NULL; result2=NULL; }

	BaseDocument*		doc;
	BaseObject*			op;
	BaseContainer*	bc;
	LONG						mode;
	LONG						flags;

	BaseObject*			result1;
	void*						result2;
};

#define SETTINGS_GENERAL							0
#define SETTINGS_MODELER							1
#define SETTINGS_DOCUMENT							2
#define SETTINGS_OBJECTMANAGER				3
#define SETTINGS_MATERIALMANAGER			4
#define SETTINGS_COORDINATEMANAGER		5
#define SETTINGS_STRUCTUREMANAGER			6
#define SETTINGS_TIMELINE							7

// GeGetSerialInfo
#define SERIAL_CINEMA4D		0
#define SERIAL_BODYPAINT	1

// GeGetVersionType
#define VERSION_CINEMA4D	(1<<0)
#define VERSION_BODYPAINT	(1<<1)
#define VERSION_NET				(1<<2)
#define VERSION_SERVER		(1<<3)
#define VERSION_DEMO			(1<<4)
#define VERSION_BENCHMARK (1<<6)

// file selector type
#define FSTYPE_ANYTHING								0
#define FSTYPE_IMAGES									1
#define FSTYPE_SCENES									2
#define FSTYPE_COFFEE									3

// document IDs
#define DOCUMENT_TIME										1000 // BASETIME
#define DOCUMENT_FPS										1001 // LONG
#define DOCUMENT_MINTIME								1002 // BASETIME
#define DOCUMENT_MAXTIME								1003 // BASETIME
#define DOCUMENT_LOOPMINTIME						1004 // BASETIME
#define DOCUMENT_LOOPMAXTIME						1005 // BASETIME
#define DOCUMENT_LOD										1006 // REAL
#define DOCUMENT_RENDERLOD							1007 // BOOL
#define DOCUMENT_USEANIMATION						1008 // BOOL
#define DOCUMENT_USEEXPRESSIONS					1009 // BOOL
#define DOCUMENT_USEGENERATORS					1010 // BOOL
#define DOCUMENT_USEDEFORMERS						1011 // BOOL
#define DOCUMENT_PATH										1012 // FILENAME
#define DOCUMENT_NAME										1013 // FILENAME
#define DOCUMENT_STATEX									1014 // BOOL
#define DOCUMENT_STATEY									1015 // BOOL
#define DOCUMENT_STATEZ									1016 // BOOL
#define DOCUMENT_STATEW									1017 // BOOL
#define DOCUMENT_CHANGED								1018 // BOOL
#define DOCUMENT_MODE										1019 // LONG
#define DOCUMENT_ACTION									1020 // LONG

#define DOCUMENT_KEYFRAMESELECTIONOBJECT		50004 // LINK
#define DOCUMENT_MULTISELECTIONWORLD				50005 // LINK
#define DOCUMENT_SELECTIONFILTER						50006 // LONG
#define DOCUMENT_DISPLAYFILTER							50007 // LONG
#define DOCUMENT_RESTRICTEDITORSELECTION		50008 // BOOL
#define DOCUMENT_RESTRICTKEYFRAMERECORDING	50009 // BOOL

#define DOCUMENT_SENDBACKTO									50010 // LONG
#define DOCUMENT_TGAFORCE										50011 // BOOL

#define	SELECTIONFILTERBIT_NULL				(1<<0)
#define	SELECTIONFILTERBIT_POLYGON		(1<<1)
#define	SELECTIONFILTERBIT_SPLINE			(1<<2)
#define	SELECTIONFILTERBIT_GENERATOR	(1<<3)
#define	SELECTIONFILTERBIT_HYPERNURBS (1<<4)
#define	SELECTIONFILTERBIT_BONE				(1<<5)
#define	SELECTIONFILTERBIT_DEFORMER		(1<<6)
#define	SELECTIONFILTERBIT_CAMERA			(1<<7)
#define	SELECTIONFILTERBIT_LIGHT			(1<<8)
#define	SELECTIONFILTERBIT_SCENE			(1<<9)
#define	SELECTIONFILTERBIT_PARTICLE		(1<<10)
#define	SELECTIONFILTERBIT_OTHER			(1<<11)

// get/set mode flags
#define MODE_EDITOR	0
#define MODE_RENDER	1
#define MODE_DEFORM	2

// maximum number of texture paths
#define MAX_GLOBAL_TEXTURE_PATHS	10

// basedraw data
#define BASEDRAW_DISABLETEXTURES				1000 // BOOL
#define BASEDRAW_DISABLEBACKCULL				1001 // BOOL
#define BASEDRAW_SHOWSAFEFRAME					1002 // BOOL
#define BASEDRAW_DISPLAYACTIVE					1003 // LONG
#define BASEDRAW_DISPLAYINACTIVE				1004 // LONG
#define BASEDRAW_USEPROPERTIESACTIVE		1005 // BOOL
#define BASEDRAW_USEPROPERTIESINACTIVE	1006 // BOOL
#define BASEDRAW_SHOWNORMALS						1007 // BOOL
#define BASEDRAW_SHOWPATH								1008 // BOOL
#define BASEDRAW_SHOWPICTURE						1009 // BOOL
#define BASEDRAW_XRAY										1010 // BOOL
#define BASEDRAW_PICTURE								1011 // FILENAME
#define BASEDRAW_OFFSETX								1012 // REAL
#define BASEDRAW_OFFSETY								1013 // REAL
#define BASEDRAW_SIZEX									1014 // REAL
#define BASEDRAW_SIZEY									1015 // REAL
#define BASEDRAW_LIGHTVECTOR						1016 // VECTOR

// identify thread
#define THREADTYPE_EDITORREDRAW		(1<<0)
#define THREADTYPE_RENDEREDITOR		(1<<1)
#define THREADTYPE_RENDEREXTERNAL	(1<<2)

typedef LONG CDialogMessage(CDialog *cd, CUserArea *cu, BaseContainer *msg);
typedef void ListViewCallBack(LONG &res_type,void *&result,void *userdata,void *secret,LONG cmd,LONG line,LONG col,void *data1);
typedef void IlluminationModel(VolumeData *sd, RayLightCache *rlc, void *dat);

typedef void ThreadMain(void *data);
typedef Bool ThreadTest(void *data);
typedef void ProgressHook(Real p, void *private_data);

typedef void *HierarchyAlloc(void *main);
typedef void HierarchyFree(void *main, void *data);
typedef void HierarchyCopyTo(void *main, void *src, void *dst);
typedef Bool HierarchyDo(void *main, void *data, BaseObject *op, const Matrix &mg, Bool controlobject);

#define VPGETINFO_XRESOLUTION	0
#define VPGETINFO_YRESOLUTION	1
#define VPGETINFO_BITDEPTH		2
#define VPGETINFO_CPP					3
#define VPGETINFO_VISIBLE			4
#define VPGETINFO_LINEOFFSET	5 // offset of component in line

#define DRAWPOLYOBJECT_FORCELINES		(1<<0)
#define DRAWPOLYOBJECT_NOBACKCULL		(1<<1)
#define DRAWPOLYOBJECT_LOCALMATRIX	(1<<2)
#define DRAWPOLYOBJECT_EDITMODE			(1<<3)

#define MSG_EMULATIONLAYER	112007

#define RENDERFLAG_EXTERNAL					(1<<0)
#define RENDERFLAG_NODOCUMENTCLONE	(1<<1)
#define RENDERFLAG_SHOWERRORS				(1<<2)

#define SOUNDCOMMAND_START				0
#define SOUNDCOMMAND_DRAGSTART		1
#define SOUNDCOMMAND_DRAGCONTINUE	2

// CheckIsRunning
#define CHECKISRUNNING_ANIMATIONRUNNING				0
#define CHECKISRUNNING_VIEWDRAWING						1
#define CHECKISRUNNING_EDITORRENDERING				2	
#define CHECKISRUNNING_EXTERNALRENDERING			3
#define CHECKISRUNNING_PAINTERUPDATING				4
#define CHECKISRUNNING_MATERIALPREVIEWRUNNING	5

struct C4D_Shader
{
	Real						(*SNoise							)(Vector p);
	Real						(*SNoiseT							)(Vector p, Real t);
	Real						(*Noise								)(Vector p);
	Real						(*NoiseT							)(Vector p, Real t);
	Real						(*PNoise							)(Vector p, Vector d);
	Real						(*PNoiseT							)(Vector p, Real t, Vector d, Real dt);
	Real						(*Turbulence					)(Vector p, Real oct, Bool abs);
	Real						(*TurbulenceT					)(Vector p, Real t, Real oct, Bool abs);
	Real						(*WavyTurbulence			)(Vector p, Real t, Real oct, Real start);
	void						(*InitFbm							)(Real *table, LONG max_octaves, Real lacunarity, Real h);
	Real						(*Fbm									)(Real *table, Vector p, Real oct);
	Real						(*FbmT								)(Real *table, Vector p, Real t, Real oct);
	Real						(*RidgedMultifractal	)(Real *table, Vector p, Real oct, Real offset, Real gain);
	Real						(*CalcSpline					)(Real x, Real *knot, LONG nknots);
	Vector					(*CalcSplineV					)(Real x, Vector *knot, LONG nknots);

	void						(*Illuminance1				)(VolumeData *sd, Vector *diffuse, Vector *specular, Real exponent);
	void						(*Illuminance2				)(VolumeData *sd, Vector *diffuse, Vector *specular, Real exponent, Vector *p, Vector *n, Vector *bumpn, Vector *rayv, LONG calc_shadow);
	Vector					(*Illuminance3				)(VolumeData *sd, Vector *p, LONG calc_shadow);
	Bool						(*IlluminateEx        )(VolumeData *sd, RayLight *rl, Vector *color, Vector *light_vector, const Vector &p, const Vector &n, LONG calc_shadow, LONG lhit);
	void						(*LightCalcSpecial    )(VolumeData *sd, RayLight *rl, const Vector &col, Real exponent, const Vector &rayv, Real cosc, const Vector &p, const Vector &bumpn, Vector *diffuse, Vector *specular);

	LONG						(*GetCurrentCPU				)(VolumeData *sd);
	LONG						(*GetCPUCount					)(VolumeData *sd);
	void*						(*GetRayData					)(VolumeData *sd, LONG i);
	Vector					(*TraceColor					)(VolumeData *sd, Ray *ray, Real maxdist, LONG lhit, Vector *p, Vector *n, LONG *hit);
	void  					(*TraceGeometry				)(VolumeData *sd, Ray *ray, Real maxdist, LONG lhit, Vector *p, Vector *n, LONG *hit);

	RayObject*			(*GetObj							)(VolumeData *sd, LONG i);
	LONG						(*GetObjCount					)(VolumeData *sd);

	RayLight*				(*GetLight						)(VolumeData *sd, LONG i);
	LONG						(*GetLightCount				)(VolumeData *sd);

	RayObject*			(*ID_to_Obj						)(VolumeData *sd, LONG id, LONG *vind);
	LONG						(*Obj_to_ID						)(VolumeData *sd, RayObject *op);

	void						(*GetUVW							)(VolumeData *sd, RayObject *op, LONG uvwind, LONG i, PolyVector *uvw);
	Vector					(*GetPointUVW					)(VolumeData *sd, TexData *tdp, LONG lhit, const Vector &p);
	void						(*GetNormals					)(VolumeData *sd, RayObject *op, LONG i, PolyVector *norm);
	TexData*				(*GetTexData					)(VolumeData *sd, RayObject *op, LONG i);
	Vector					(*GetNormal						)(VolumeData *sd, RayObject *op, LONG i);
	Vector					(*GetSmoothedNormal		)(VolumeData *sd, LONG id, const Vector &p);
	Bool						(*GetRS								)(VolumeData *sd, LONG id, const Vector &p, Real *r, Real *s);

	void						(*GetRay							)(VolumeData *sd, Real x, Real y, Ray *ray);
	Vector					(*ScreenToCamera			)(VolumeData *sd, const Vector &p);
	Vector					(*CameraToScreen			)(VolumeData *sd, const Vector &p);
	Bool						(*ProjectPoint				)(VolumeData *sd, TexData *tdp, LONG lhit, const Vector &p, const Vector &n, Vector *uv);

	Vector					(*CalcHardShadow			)(VolumeData *sd, const Vector &p1, const Vector &p2, Bool transparency, LONG lhit);
	Vector					(*CalcShadow					)(VolumeData *sd, RayLight *l, const Vector &p, const Vector &n, Bool transparency, LONG lhit);

	VolumeData*			(*AllocVolumeData			)(void);
	void						(*FreeVolumeData			)(VolumeData *sd);

	Bool						(*Illuminate					)(VolumeData *sd, RayLight *rl, Vector *color, Vector *light_vector, const Vector &p, const Vector &n, LONG calc_shadow, LONG lhit, Vector *xshadow);

	void						(*StatusSetText				)(VolumeData *sd, const String *str);
	void						(*StatusSetBar				)(VolumeData *sd, Real percentage);

	TexData*				(*AllocTexData				)(void);
	void						(*FreeTexData					)(TexData *td);
	void						(*InitTexData					)(TexData *td);

	Vector					(*CalcVisibleLight		)(VolumeData *sd, Ray *ray, Real maxdist, Vector *trans);
	void						(*GetDUDV							)(VolumeData *vd, TexData *tex, const Vector &p, const Vector &n, Vector *ddu, Vector *ddv);
	void						(*GetXY								)(VolumeData *sd, LONG *x, LONG *y, LONG *scale);

	LONG						(*Obj_to_Num					)(VolumeData *sd, RayObject *obj);
	LONG						(*Light_to_Num				)(VolumeData *sd, RayLight *light);

	Bool						(*GetVideopostEx			)(VolumeData *sd, LONG i, LONG *id, VIDEOPOST **vp, VP_DATA **data);
	LONG						(*GetVideopostCountEx	)(VolumeData *sd);

	void						(*CopyVolumeData			)(VolumeData *src, VolumeData *dst);
	Vector					(*TraceColorDirect		)(VolumeData *sd, Ray *ray, Real maxdist, LONG raydepth, LONG raybits, LONG lhit, LVector *p, LVector *n, LONG *hit);

	Bool						(*VPAllocateBuffer		)(Render *render, LONG id, LONG subid, LONG bitdepth, Bool visible);
	VPBuffer*				(*VPGetBuffer					)(Render *render, LONG id, LONG subid);
	LONG						(*VPGetInfo						)(VPBuffer *buf, LONG type);
	Bool						(*VPGetLine						)(VPBuffer *buf, LONG x, LONG y, LONG cnt, void *data, LONG bitdepth, Bool dithering);
	Bool						(*VPSetLine						)(VPBuffer *buf, LONG x, LONG y, LONG cnt, void *data, LONG bitdepth, Bool dithering);
	LONG						(*VPSaveEx						)(VPBuffer *buf, const Filename *name, LONG format, BaseContainer *data, LONG savebits);

	void						(*OutOfMemory					)(VolumeData *sd);
	void  					(*GetSurfaceData			)(VolumeData *sd, SurfaceData *cd, Bool calc_illum, Bool calc_shadow, Bool calc_refl, Bool calc_trans, Ray *ray, const Vector &p, const Vector &n, LONG lhit);
	Real						(*GetLightFalloff			)(LONG falloff, Real inner, Real outer, Real dist);

	Bool						(*TestBreak						)(VolumeData *sd);

	void						(*VPRegisterBufferEx	)(Render *render, LONG id, LONG bitdepth, LONG cpp, const String *name);
	void						(*VPUpdateLineEx			)(Render *render, LONG line);
	void						(*VPUpdateScreenEx		)(Render *render);
	void						(*VPGetRenderData			)(Render *render, BaseContainer *bc);
	void						(*VPSetRenderData			)(Render *render, const BaseContainer *bc);

	void						(*Illuminance					)(VolumeData *sd, Vector *diffuse, Vector *specular, IlluminationModel *model, void *data);

	PluginVideoPost*(*FindVideoPost				)(VolumeData *sd, LONG i, Bool index);
	VPFragment**		(*VPGetFragments			)(VolumeData *sd, LONG x, LONG y, LONG cnt, LONG flags);
	Bool						(*AddLensGlow					)(VolumeData *sd, LensGlowStruct *lgs, Vector *lgs_pos, LONG lgs_cnt, Real intensity);
	
	void						(*VPUpdateScreen			)(Render *render);

	RayLight*				(*AllocRayLight				)(BaseObject *op);
	void						(*FreeRayLight				)(RayLight *lgt);

	RayFilter*			(*RfAllocRayFilter		)(LONG xres, LONG yres, LONG components, LONG left, LONG right, LONG type, Real softness, Bool dithering);
	void						(*RfFreeRayFilter			)(RayFilter *filter);
	void						(*RfAddLine						)(RayFilter *filter, Real *line, LONG y);
	void						(*RfEvaluateLine			)(RayFilter *filter, Bool display, LONG y, LONG xcnt, BaseBitmap *bmp, LONG alpha);
	LONG						(*RfGetYRadius				)(RayFilter *filter);
	void						(*RfSetRange					)(RayFilter *filter, LONG t_top, LONG t_bottom);
	
	UWORD*					(*GetFragmentMask			)(VolumeData *sd);
	LONG						(*TranslateObjIndex		)(VolumeData *sd, LONG index, Bool old_to_new);
	Bool						(*TranslatePolygon		)(VolumeData *sd, RayObject *op, LONG local_index, Vector *previous_points);
	Bool						(*SampleLensFX				)(VolumeData *sd, VPBuffer *rgba, VPBuffer *fx, BaseThread *bt);
	LONG						(*VPAllocateBufferFX	)(Render *render, LONG id, const String &name, LONG bitdepth, Bool visible);

	VolumeData*			(*VPGetInitialVolumeData)(Render *render, LONG cpu);
	Bool						(*SetRayTolerance			)(VolumeData *sd, Real value);
};

struct C4D_HyperFile
{
	Bool						(*WriteChar						)(HyperFile *hf, CHAR  v);
	Bool						(*WriteUChar					)(HyperFile *hf, UCHAR v);
	Bool						(*WriteWord						)(HyperFile *hf, WORD  v);
	Bool						(*WriteUWord					)(HyperFile *hf, UWORD v);
	Bool						(*WriteLong						)(HyperFile *hf, LONG  v);
	Bool						(*WriteULong					)(HyperFile *hf, ULONG v);
	Bool						(*WriteReal						)(HyperFile *hf, Real  v);
	Bool						(*WriteLReal					)(HyperFile *hf, LReal v);
	Bool						(*WriteBool						)(HyperFile *hf, Bool  v);
	Bool						(*WriteTime						)(HyperFile *hf, const BaseTime &v);
	Bool						(*WriteVector					)(HyperFile *hf, const Vector &v);
	Bool						(*WriteLVector				)(HyperFile *hf, const LVector &v);
	Bool						(*WriteMatrix					)(HyperFile *hf, const Matrix &v);
	Bool						(*WriteLMatrix				)(HyperFile *hf, const LMatrix &v);
	Bool						(*WriteString					)(HyperFile *hf, const String *v);
	Bool						(*WriteFilename				)(HyperFile *hf, const Filename *v);
	Bool						(*WriteImage					)(HyperFile *hf, BaseBitmap *v, LONG format, const BaseContainer *data);
	Bool						(*WriteContainer			)(HyperFile *hf, const BaseContainer *v);
	Bool						(*WriteMemory					)(HyperFile *hf, void *data, LONG count);

	Bool						(*ReadChar						)(HyperFile *hf, CHAR          *v);
	Bool						(*ReadUChar						)(HyperFile *hf, UCHAR         *v);
	Bool						(*ReadWord						)(HyperFile *hf, WORD          *v);
	Bool						(*ReadUWord					  )(HyperFile *hf, UWORD         *v);
	Bool						(*ReadLong					  )(HyperFile *hf, LONG          *v);
	Bool						(*ReadULong					  )(HyperFile *hf, ULONG         *v);
	Bool						(*ReadReal					  )(HyperFile *hf, Real          *v);
	Bool						(*ReadLReal					  )(HyperFile *hf, LReal         *v);
	Bool						(*ReadBool					  )(HyperFile *hf, Bool          *v);
	Bool						(*ReadTime						)(HyperFile *hf, BaseTime      *v);
	Bool						(*ReadVector					)(HyperFile *hf, Vector        *v);
	Bool						(*ReadLVector					)(HyperFile *hf, LVector       *v);
	Bool						(*ReadMatrix					)(HyperFile *hf, Matrix        *v);
	Bool						(*ReadLMatrix					)(HyperFile *hf, LMatrix       *v);
	Bool						(*ReadString					)(HyperFile *hf, String       *v);
	Bool						(*ReadFilename				)(HyperFile *hf, Filename     *v);
	Bool						(*ReadImage						)(HyperFile *hf, BaseBitmap   *v);
	Bool						(*ReadContainer				)(HyperFile *hf, BaseContainer *v, Bool flush);
	Bool						(*ReadMemory					)(HyperFile *hf, void **data, LONG *size);

	LONG						(*GetError						)(HyperFile *hf);
	void						(*SetError						)(HyperFile *hf, LONG err);
	Bool						(*ReadValueHeader			)(HyperFile *hf, UCHAR *h);
	Bool						(*SkipValue						)(HyperFile *hf, UCHAR h);
	Bool						(*WriteChunkStart			)(HyperFile *hf, LONG id, LONG level);
	Bool						(*WriteChunkEnd				)(HyperFile *hf);
	Bool						(*ReadChunkStart			)(HyperFile *hf, LONG *id, LONG *level);
	Bool						(*ReadChunkEnd				)(HyperFile *hf);
	Bool						(*SkipToEndChunk			)(HyperFile *hf);
	BaseDocument*		(*GetDocument					)(HyperFile *hf);

	LONG						(*ReadFile						)(BaseDocument *doc, GeListNode *node, const Filename &filename, LONG ident, String *warning_string);
	LONG						(*WriteFile						)(BaseDocument *doc, GeListNode *node, const Filename &filename, LONG ident);

	LONG						(*GetFileVersion			)(HyperFile *hf);
};

struct C4D_BaseContainer
{
	BaseContainer		*Default;

	// container
	BaseContainer*	(*Alloc								)(LONG id);
	void						(*Free								)(BaseContainer *killme);

	BaseContainer*	(*GetClone						)(const BaseContainer *bc);
	void						(*FlushAll						)(BaseContainer *bc);
	LONG						(*GetId								)(const BaseContainer *bc);
	void						(*SetId								)(BaseContainer *bc, LONG newid);
	Bool						(*Compare							)(const BaseContainer *bc1,const BaseContainer *bc2);

	Bool						(*SetReal							)(BaseContainer *bc, LONG id, Real v);
	Bool						(*SetBool							)(BaseContainer *bc, LONG id, Bool v);
	Bool						(*SetLong							)(BaseContainer *bc, LONG id, LONG v);
	Bool						(*SetString						)(BaseContainer *bc, LONG id, const String *v);
	Bool						(*SetFilename					)(BaseContainer *bc, LONG id, const Filename *v);
	Bool						(*SetBaseTime					)(BaseContainer *bc, LONG id, const BaseTime &v);
	Bool						(*SetContainer				)(BaseContainer *bc, LONG id, const BaseContainer *v);
	Bool						(*SetVector						)(BaseContainer *bc, LONG id, const Vector &v);
	Bool						(*SetMatrix						)(BaseContainer *bc, LONG id, const Matrix &v);

	Real						(*GetReal							)(const BaseContainer *bc, LONG id);
	Bool						(*GetBool							)(const BaseContainer *bc, LONG id);
	LONG						(*GetLong							)(const BaseContainer *bc, LONG id);
	String*					(*GetString						)(const BaseContainer *bc, LONG id);
	Filename*				(*GetFilename					)(const BaseContainer *bc, LONG id);
	BaseTime				(*GetBaseTime					)(const BaseContainer *bc, LONG id);
	BaseContainer*	(*GetContainer			  )(const BaseContainer *bc, LONG id);
	Vector					(*GetVector						)(const BaseContainer *bc, LONG id);
	Matrix					(*GetMatrix					  )(const BaseContainer *bc, LONG id);
	Bool						(*RemoveData					)(BaseContainer *bc, LONG id);
	LONG						(*FindIndex						)(const BaseContainer *bc, LONG id);
	LONG						(*GetIndexId					)(const BaseContainer *bc, LONG index);
	Bool						(*RemoveIndex					)(BaseContainer *bc, LONG index);
	Bool						(*CopyToEx						)(const BaseContainer *bc, BaseContainer *dest);
	LONG						(*GetIndexType				)(const BaseContainer *bc, LONG index);

	GeData*					(*GetIndexData				)(const BaseContainer *bc, LONG index);
	Bool						(*InsData							)(BaseContainer *bc, LONG id, const GeData *n);
	Bool						(*SetData							)(BaseContainer *bc, LONG id, const GeData *n);

	BaseList2D*			(*GetLink							)(const BaseContainer *bc, LONG id, BaseDocument *doc, LONG instanceof);
	Bool						(*SetLink							)(BaseContainer *bc, LONG id, BaseList2D *link);

	void						(*Init								)(BaseContainer *bc, LONG id);

	void*						(*BrowseContainer			)(const BaseContainer *bc, LONG *id, GeData **data, void *handle);
	void						(*MergeContainer			)(BaseContainer *dst, const BaseContainer &src);

	const GeData&		(*GetData							)(const BaseContainer *bc, LONG id);
	Bool						(*GetParameter				)(BaseContainer *dst, const DescID &id, GeData &t_data);
	Bool						(*SetParameter				)(BaseContainer *dst, const DescID &id, const GeData &t_data);
	Bool						(*CopyTo							)(const BaseContainer *bc, BaseContainer *dest,AliasTrans *trans);
};

struct C4D_GeData
{
	void            (*Free                )(GeData *data);
	Bool            (*IsEqual             )(const GeData *data,const GeData *data2);
	LONG						(*GetType							)(const GeData *data);
	void            (*CopyData						)(GeData *dest,const GeData *src,AliasTrans *aliastrans);

	Bool						(*SetNil              )(GeData *data);
	Bool						(*SetLong             )(GeData *data,LONG n);
	Bool						(*SetReal             )(GeData *data,Real n);
	Bool						(*SetVector           )(GeData *data,const Vector &n);
	Bool						(*SetMatrix           )(GeData *data,const Matrix &n);
	Bool						(*SetString           )(GeData *data,const String *n);
	Bool            (*SetFilename         )(GeData *data,const Filename *n);
	Bool            (*SetBaseTime         )(GeData *data,const BaseTime &n);
	Bool            (*SetBaseContainer    )(GeData *data,const BaseContainer *n);
	Bool            (*SetLink             )(GeData *data,const BaseLink &n);

	LONG						(*GetLong							)(const GeData *data);
	Real						(*GetReal							)(const GeData *data);
	const Vector&		(*GetVector						)(const GeData *data);
	const Matrix&		(*GetMatrix						)(const GeData *data);
	const String&		(*GetString						)(const GeData *data);
	const Filename&	(*GetFilename					)(const GeData *data);
	const BaseTime&	(*GetTime							)(const GeData *data);
	BaseContainer*	(*GetContainer				)(const GeData *data);
	BaseLink*				(*GetLink             )(const GeData *data);

	Bool            (*SetCustomData				)(GeData *data,LONG type,const CustomDataType &n);
	CustomDataType* (*GetCustomData				)(const GeData *data,LONG type);
	Bool            (*InitCustomData			)(GeData *data,LONG type);
};

struct C4D_String
{
	// safety value
	String					*Default;

	// strings
	String*					(*Alloc								)(void);
	String*					(*AllocCString				)(CHAR *txt, LONG count, StringEncoding type);
	String*					(*AllocArray					)(LONG count, UWORD fillchr);
	void						(*Free								)(String *str);
 	String*					(*GetClone						)(const String *src);
	LONG						(*GetLength						)(const String *str);
	Bool						(*Add									)(String *dst,const String *src);

	LONG						(*Compare							)(const String *str1, const String *str2,LONG flag);
	Bool						(*FindFirst						)(const String *str, const String *find, LONG *pos, LONG start);
	Bool						(*FindLast						)(const String *str, const String *find, LONG *pos, LONG start);
  Bool						(*Delete							)(String *str,LONG pos,LONG count);
	void						(*Insert							)(String *str,LONG pos, const String *ins);
	String*					(*SubStr							)(const String *str,LONG start, LONG count);

	Real						(*ToReal							)(const String *str,LONG *error, LONG einheit, LONG winkelart, LONG basis);
	LONG						(*ToLong							)(const String *str, LONG *error);

	String*					(*RealToString				)(Real v, LONG vk, LONG nk, Bool e, UWORD xchar);
	String*					(*LongToString				)(LONG l);

	String*					(*ToUpper							)(const String *str);
	String*					(*ToLower							)(const String *str);

	LONG						(*GetCStringLen				)(const String *str,StringEncoding type);
	LONG						(*GetCString					)(const String *str,CHAR *cstr, LONG max, StringEncoding type);

	UWORD						(*GetChr							)(const String *str,LONG pos);
	void						(*SetChr							)(String *str,LONG pos,UWORD chr);

	void						(*Init								)(String *str);
	void						(*InitCString					)(String *str, const CHAR *txt, LONG count, StringEncoding type);
	void						(*InitArray						)(String *str, LONG count, UWORD fillchr);
	void						(*Flush								)(String *str);
	void						(*CopyTo							)(const String *src, String *dst);
};

struct C4D_Bitmap
{
	BaseBitmap*			(*Alloc								)(void);
	void						(*Free								)(BaseBitmap *bm);
	BaseBitmap*			(*GetClone						)(BaseBitmap *src);
	LONG						(*GetBw								)(BaseBitmap *bm);
	LONG						(*GetBh								)(BaseBitmap *bm);
	LONG						(*GetBt								)(BaseBitmap *bm);
	LONG						(*GetBpz							)(BaseBitmap *bm);
	LONG						(*Init1								)(BaseBitmap *bm, LONG x, LONG y, LONG depth);
	LONG					  (*Init2								)(BaseBitmap *bm, const Filename *name, LONG frame, Bool *ismovie);
	void					  (*FlushAll						)(BaseBitmap *bm);
	LONG				    (*Save								)(BaseBitmap *bm, const Filename *name, LONG format, const BaseContainer *data, LONG savebits);
	void						(*GetLine							)(BaseBitmap *bm, LONG y, void *data);
	void						(*SetLine							)(BaseBitmap *bm, LONG y, void *data, LONG depth);
	void						(*GetAlphaLine				)(BaseBitmap *bm, LONG y, void *data, LONG channel);
	void						(*SetAlphaLine				)(BaseBitmap *bm, LONG y, void *data, LONG channel);
	void						(*SetCMAP							)(BaseBitmap *bm, LONG i, LONG r, LONG g, LONG b);
	void						(*ScaleIt							)(BaseBitmap *src, BaseBitmap *dst, LONG intens, Bool sample, Bool nprop);
	void						(*SetPen							)(BaseBitmap *bm, LONG r, LONG g, LONG b);
	void						(*Clear								)(BaseBitmap *bm, LONG x1, LONG y1, LONG x2, LONG y2, LONG r, LONG g, LONG b);
	void						(*Line								)(BaseBitmap *bm, LONG x1, LONG y1, LONG x2, LONG y2);
	void						(*SetPixel						)(BaseBitmap *bm, LONG x, LONG y, LONG r, LONG g, LONG b);
	void						(*GetPixel						)(BaseBitmap *bm, LONG x, LONG y, UWORD *r, UWORD *g, UWORD *b);
	LONG						(*AddChannel					)(BaseBitmap *bm, Bool internal, Bool straight);
	void						(*RemoveChannel				)(BaseBitmap *bm, LONG channel);
	void						(*GetAlphaPixel				)(BaseBitmap *bm, LONG channel, LONG x, LONG y, UWORD *val);
	void						(*SetAlphaPixel				)(BaseBitmap *bm, LONG channel, LONG x, LONG y, LONG val);
	LONG						(*SaveChannel					)(BaseBitmap *bm, LONG channel, const Filename *name);
	LONG						(*GetInternalChannel	)(BaseBitmap *bm);
	LONG						(*GetChannelCount			)(BaseBitmap *bm);
	LONG						(*GetChannelNum				)(BaseBitmap *bm, LONG num);
	BaseBitmap*			(*GetClonePart				)(BaseBitmap *src, LONG x, LONG y, LONG w, LONG h);
	void						(*SetPixelCnt					)(BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc);
	void						(*GetPixelCnt					)(BaseBitmap *bm, LONG x, LONG y, LONG cnt, UCHAR *buffer, LONG inc);
	Bool						(*CopyTo							)(BaseBitmap *src, BaseBitmap *dst);
};

struct C4D_MovieSaver
{
	MovieSaver*			(*Alloc								)(void);
	void						(*Free								)(MovieSaver *ms);
	LONG						(*Open								)(MovieSaver *ms, const Filename *name, BaseBitmap *bm, LONG fps, LONG id, const BaseContainer *data, LONG savebits);
	LONG						(*Write								)(MovieSaver *ms, BaseBitmap *bm);
	void						(*Close								)(MovieSaver *ms);
	Bool						(*Choose							)(MovieSaver *ms, LONG id, BaseContainer *bc);
};

struct C4D_BaseChannel
{
	// channels
	BaseChannel*		(*Alloc								)(void);
	BaseChannel*		(*GetCloneEx					)(BaseChannel *bc);
	void						(*Free								)(BaseChannel *bc);
	Bool						(*Compare							)(BaseChannel *bc1,BaseChannel *bc2);
	LONG						(*InitTexture					)(BaseChannel *bc, InitRenderStruct *irs);
	void						(*FreeTexture					)(BaseChannel *bc);
	Vector					(*SampleEx						)(BaseChannel *bc, VolumeData *vd, Vector *p, Vector *delta, Vector *n, Real t, LONG tflag, Real off, Real scale);
	BaseBitmap*			(*GetBitmap						)(BaseChannel *bc);
	void						(*GetData							)(BaseChannel *bc, BaseContainer *ct);
	void						(*SetData							)(BaseChannel *bc, const BaseContainer *ct);
	Bool						(*ReadData						)(HyperFile *hf, BaseChannel *bc);
	Bool						(*WriteData						)(HyperFile *hf, BaseChannel *bc);

	_TextureGroup*	(*DlgAlloc						)(BaseChannel *bc, CDialog *cd, CUserArea *cupreview, LONG idimage, LONG idname, LONG idbluroff, LONG idblurstr, LONG idint, LONG idinfo, LONG idpreview, LONG idedit, LONG idpopup);
	void						(*DlgFree							)(_TextureGroup *tg);
	Bool						(*DlgMessage					)(_TextureGroup *th, const BaseContainer *msg, Bool preview);

	Bool						(*MessageEx           )(BaseChannel *bc, LONG id, void *data);
	void*						(*GetPluginDataEx			)(BaseChannel *bc);
	LONG						(*GetPluginID					)(BaseChannel *bc);

	CHANNELSHADER*	(*GetShaderEx					)(BaseChannel *bc);
	PluginShader*		(*GetPluginShader			)(BaseChannel *bc);

	Bool						(*Attach							)(BaseChannel *bc, GeListNode *element);
};

struct C4D_Filename
{
	// safety value
	Filename				*Default;

	Filename*				(*Alloc								)(void);
	Filename*				(*GetClone						)(const Filename *fn);
	void						(*Free								)(Filename *fn);
	Bool						(*FileSelect					)(Filename *fn,LONG type, LONG flags, const String *title);
	Bool						(*Content							)(const Filename *fn);
	String*					(*GetString						)(const Filename *fn);
	void						(*SetString						)(Filename *fn, const String *str);
	Filename*				(*GetDirectory				)(const Filename *fn);
	Filename*				(*GetFile							)(const Filename *fn);
	void						(*ClearSuffix					)(Filename *fn);
	void						(*SetSuffix						)(Filename *fn, const String *str);
	Bool						(*CheckSuffix					)(const Filename *fn, const String *str);
	void						(*SetDirectory				)(Filename *fn, const Filename *str);
	void						(*SetFile							)(Filename *fn, const Filename *str);
	Bool						(*Compare							)(const Filename *fn1, const Filename *fn2);
	void						(*Add									)(Filename *dst, const Filename *src);

	void						(*Init								)(Filename *fn);
	void						(*Flush								)(Filename *fn);
	void						(*CopyTo							)(const Filename *src, Filename *dst);
};

struct C4D_BrowseFiles
{
	BrowseFiles*		(*Alloc								)(const Filename *dir, Bool calcsize);
	void						(*Free								)(BrowseFiles *bf);
	Bool						(*GetNext							)(BrowseFiles *bf);
	LONG						(*GetSize							)(BrowseFiles *bf);
	Bool						(*IsDir								)(BrowseFiles *bf);
	Filename*				(*GetFilename					)(BrowseFiles *bf);
	void						(*Init								)(BrowseFiles *bf, const Filename *dir, Bool calcsize);
};

struct C4D_File
{
	BaseFile*				(*Alloc								)(void);
	void						(*Free								)(BaseFile *fl);
	Bool						(*Open								)(BaseFile *fl, const Filename *name, LONG mode, LONG error_dialog, LONG order, LONG type, LONG creator);
	Bool						(*Close								)(BaseFile *fl);
	void						(*SetOrder						)(BaseFile *fl, LONG order);
	LONG						(*ReadBytes						)(BaseFile *fl, void *data, LONG len, Bool just_try_it);
	LONG						(*WriteBytes					)(BaseFile *fl, void *data, LONG len);
	Bool						(*Seek								)(BaseFile *fl, LONG pos, LONG mode);
	LONG						(*GetPosition					)(BaseFile *fl);
	LONG						(*GetLength						)(BaseFile *fl);
	LONG						(*GetError						)(BaseFile *fl);
	void						(*SetError						)(BaseFile *fl, LONG error);
	Bool						(*WriteChar						)(BaseFile *fl, CHAR  v);
	Bool						(*WriteUChar					)(BaseFile *fl, UCHAR v);
	Bool						(*WriteWord						)(BaseFile *fl, WORD  v);
	Bool						(*WriteUWord					)(BaseFile *fl, UWORD v);
	Bool						(*WriteLong						)(BaseFile *fl, LONG  v);
	Bool						(*WriteULong					)(BaseFile *fl, ULONG v);
	Bool						(*WriteReal						)(BaseFile *fl, Real  v);
	Bool						(*WriteLReal					)(BaseFile *fl, LReal v);
	Bool						(*ReadChar						)(BaseFile *fl, CHAR  *v);
	Bool						(*ReadUChar						)(BaseFile *fl, UCHAR *v);
	Bool						(*ReadWord						)(BaseFile *fl, WORD  *v);
	Bool						(*ReadUWord						)(BaseFile *fl, UWORD *v);
	Bool						(*ReadLong						)(BaseFile *fl, LONG  *v);
	Bool						(*ReadULong						)(BaseFile *fl, ULONG *v);
	Bool						(*ReadReal						)(BaseFile *fl, Real  *v);
	Bool						(*ReadLReal						)(BaseFile *fl, LReal *v);
};

struct C4D_Dialog
{
	CDialog*				(*Alloc									)(CDialogMessage *dlgfunc,void *userdata);
	void						(*Free									)(CDialog *cd);
	void*						(*GetUserData						)(CDialog *cd);
	CUserArea*			(*AttachUserAreaEx			)(CDialog *cd, LONG id,void *userdata);
	Bool						(*OpenEx								)(CDialog *cd, Bool async, CDialog *parent, LONG xpos, LONG ypos);
	Bool						(*Close									)(CDialog *cd);
	Bool						(*SendUserAreaMessage		)(CDialog *cd, LONG id, BaseContainer *msg,void *gadptr);
	Bool						(*Enable								)(CDialog *cd, LONG id, Bool enabled,void *gadptr);
	void						(*SetTimer							)(CDialog *cd, LONG timer);
	Bool						(*SetLong								)(CDialog *cd, LONG id, LONG value,LONG min,LONG max,LONG step,void *gadptr);
	Bool						(*SetReal								)(CDialog *cd, LONG id, Real value,Real min,Real max,Real step,LONG format,void *gadptr);
	Bool						(*SetVector							)(CDialog *cd, LONG id, const Vector &value,void *gadptr);
	Bool						(*SetString							)(CDialog *cd, LONG id, const String *text,void *gadptr);
	Bool						(*SetColorField					)(CDialog *cd, LONG id, const Vector &color, Real brightness,Real maxbrightness,LONG flags,void *gadptr);
	Bool						(*GetLong								)(CDialog *cd, LONG id, LONG &value,void *gadptr);
	Bool						(*GetReal								)(CDialog *cd, LONG id, Real &value,void *gadptr);
	Bool						(*GetVector							)(CDialog *cd, LONG id, Vector &value,void *gadptr);
	Bool						(*GetString							)(CDialog *cd, LONG id, String *&text,void *gadptr);
	Bool						(*GetColorField					)(CDialog *cd, LONG id, Vector &color, Real &brightness,void *gadptr);
	Bool						(*AddGadgetEx						)(CDialog *cd, LONG type, LONG id, const String *name,LONG par1,LONG par2, LONG par3, LONG par4);
	Bool						(*LoadDialogResource		)(CDialog *cd, LONG id, LocalResource *lr, LONG flags);
	Bool						(*TabGroupBegin					)(CDialog *cd, LONG id, LONG flags,LONG tabtype);
	Bool						(*GroupBegin						)(CDialog *cd, LONG id, LONG flags,LONG cols,LONG rows,const String *title,LONG groupflags);
	Bool						(*GroupSpace						)(CDialog *cd, LONG spacex,LONG spacey);
	Bool						(*GroupBorder						)(CDialog *cd, LONG borderstyle);
	Bool						(*GroupBorderSize				)(CDialog *cd, LONG left, LONG top,LONG right,LONG bottom);
	Bool						(*GroupEnd							)(CDialog *cd);
	Bool						(*SetPopup							)(CDialog *cd, LONG id, const BaseContainer *bc,void *gadptr);
	Bool						(*Screen2Local					)(CDialog *cd, LONG *x, LONG *y);
	Bool						(*SetVisibleArea				)(CDialog *cd, LONG scrollgroupid, LONG x1, LONG y1,LONG x2,LONG y2);
	Bool						(*GetItemDim						)(CDialog *cd, LONG id, LONG *x, LONG *y, LONG *w, LONG *h,void *gadptr);
	Bool						(*ScrollGroupBeginEx		)(CDialog *cd, LONG id, LONG flags,LONG scrollflags);
	Bool						(*SendRedrawThread			)(CDialog *cd, LONG id);
	Bool            (*GetVisibleArea				)(CDialog *cd, LONG id, LONG *x1,LONG *y1,LONG *x2,LONG *y2);
	Bool						(*RestoreLayout					)(CDialog *cd, void *secret);
	Bool						(*SetMessageResult			)(CDialog *cd, const BaseContainer *result);
	Bool            (*GetDragObjectEx				)(CDialog *cd, const BaseContainer *msg,LONG *type,void **object);

	Bool            (*SetDragDestination		)(CDialog *cd, LONG cursor);
	Bool						(*AttachSubDialog				)(CDialog *parentcd,LONG id,CDialog *cd);
	LONG						(*GetID									)(CDialog *cu);
	void*						(*FindCustomGui					)(CDialog *cd,LONG id);
	Bool						(*AddGadget							)(CDialog *cd, LONG type, LONG id, const String *name,LONG par1,LONG par2, LONG par3, LONG par4,const BaseContainer *customdata,void **resptr);
	Bool						(*ReleaseLink						)(CDialog *cd);
	Bool						(*SendParentMessage			)(CDialog *cd,const BaseContainer *msg);
	Bool						(*Open									)(CDialog *cd, Bool async, CDialog *parent, LONG xpos, LONG ypos,LONG defaultw,LONG defaulth);
	CUserArea*			(*AttachUserArea				)(CDialog *cd, LONG id,void *userdata,LONG userareaflags,void *gadptr);
	Bool            (*GetDragObject					)(CDialog *cd, const BaseContainer *msg,LONG *type,void **object);

	LassoSelection*	(*LSAlloc								)(void);
	void						(*LSFree								)(LassoSelection *ls);
	LONG						(*LSGetMode							)(LassoSelection *ls);
	Bool						(*LSTest								)(LassoSelection *ls, LONG x, LONG y);
	Bool						(*LSCheckSingleClick		)(LassoSelection *ls);
	Bool						(*LSStart								)(LassoSelection *ls, CBaseFrame *cd, LONG mode, LONG start_x, LONG start_y, LONG start_button,LONG sx1, LONG sy1, LONG sx2, LONG sy2);
	Bool						(*LSTestPolygon					)(LassoSelection *ls, const Vector &pa, const Vector &pb, const Vector &pc, const Vector &pd);

	CBaseFrame*			(*CBF_FindBaseFrame			)(CDialog *cd,LONG id);
	Bool						(*CBF_SetDragDestination)(CBaseFrame *cbf,LONG cursor);
	void*						(*CBF_GetWindowHandle		)(CBaseFrame *cbf);
};

struct C4D_UserArea
{
	void						(*Free                )(CUserArea* cu);
	void*						(*GetUserData         )(CUserArea *cu);
	LONG						(*GetWidth            )(CUserArea *cu);
	LONG						(*GetHeight           )(CUserArea *cu);
	LONG						(*GetID               )(CUserArea *cu);
	void						(*SetMinSize          )(CUserArea *cu, LONG w,LONG h);
	void						(*DrawLine            )(CUserArea *cu, LONG x1,LONG y1,LONG x2,LONG y2);
	void						(*DrawRectangle       )(CUserArea *cu, LONG x1,LONG y1,LONG x2,LONG y2);
	void						(*DrawSetPenV         )(CUserArea *cu, const Vector &color);
	void						(*DrawSetPenI         )(CUserArea *cu, LONG id);
	void						(*SetTimer            )(CUserArea *cu, LONG timer);
	Bool						(*GetInputState       )(CBaseFrame *cu, LONG askdevice,LONG askchannel,BaseContainer *res);
	Bool						(*GetInputEvent       )(CBaseFrame *cu, LONG askdevice,BaseContainer *res);
	void						(*KillEvents          )(CBaseFrame *cu);
	void						(*DrawSetFont         )(CUserArea *cu, LONG fontid);
	LONG						(*DrawGetTextWidth    )(CUserArea *cu, const String *text);
	LONG						(*DrawGetFontHeight   )(CUserArea *cu);
	void						(*DrawSetTextColII    )(CUserArea *cu, LONG fg,LONG bg);
	void						(*DrawSetTextColVI    )(CUserArea *cu, const Vector &fg,LONG bg);
	void						(*DrawSetTextColIV    )(CUserArea *cu, LONG fg,const Vector &bg);
	void						(*DrawSetTextColVV    )(CUserArea *cu, const Vector &fg,const Vector &bg);
	void						(*DrawText            )(CUserArea *cu, const String *txt,LONG x,LONG y);
	void						(*DrawBitmap          )(CUserArea *cu, BaseBitmap *bmp,LONG wx,LONG wy,LONG ww,LONG wh,LONG x,LONG y,LONG w,LONG h,LONG mode);
	void						(*SetClippingRegion   )(CUserArea *cu, LONG x,LONG y,LONG w,LONG h);
	void						(*ScrollArea          )(CUserArea *cu, LONG xdiff,LONG ydiff,LONG x,LONG y,LONG w,LONG h);
	void						(*ClearClippingRegion )(CUserArea *cu);
	Bool						(*OffScreenOn         )(CUserArea *cu);

	Bool						(*Global2Local        )(CBaseFrame *cu, LONG *x,LONG *y);
	Bool						(*SendParentMessage   )(CUserArea *cu, const BaseContainer *msg);

	Bool						(*Screen2Local        )(CBaseFrame *cu, LONG *x, LONG *y);
	Bool            (*SetDragDestination  )(CUserArea *cu, LONG cursor);
	Bool            (*HandleMouseDrag     )(CUserArea *cu, const BaseContainer *msg,LONG type,void *data,Bool privateframe);
	Bool						(*IsEnabled           )(CUserArea *cu);

	void						(*GetBorderSize       )(CUserArea *cu,LONG type,LONG *l,LONG *t,LONG *r,LONG *b);
	void            (*DrawBorder          )(CUserArea *cu,LONG type,LONG x1,LONG y1,LONG x2,LONG y2);

	_GeListView*		(*GeListView_Alloc            )(void);
	void						(*GeListView_Free             )(_GeListView *lv);
	Bool            (*GeListView_Attach           )(_GeListView *lv,CDialog *cd,LONG id,ListViewCallBack *callback,void *userdata);
	void            (*GeListView_LvSuperCall      )(_GeListView *lv,LONG &res_type,void *&result,void *secret,LONG cmd,LONG line,LONG col);
	void            (*GeListView_Redraw           )(_GeListView *lv);
	void            (*GeListView_DataChanged      )(_GeListView *lv);
	Bool            (*GeListView_ExtractMouseInfo )(_GeListView *lv,void *secret,MouseDownInfo &info,LONG size);
	Bool            (*GeListView_ExtractDrawInfo  )(_GeListView *lv,void *secret,DrawInfo &info,LONG size);
	Bool            (*GeListView_SendParentMessage)(_GeListView *lv,const BaseContainer *msg);
	LONG						(*GeListView_GetId            )(_GeListView *lv);

	_SimpleListView* (*SimpleListView_Alloc       )(void);
	void            (*SimpleListView_Free         )(_SimpleListView *lv);
	Bool            (*SimpleListView_SetLayout    )(_SimpleListView *lv,LONG columns,const BaseContainer &data);
	Bool            (*SimpleListView_SetItem      )(_SimpleListView *lv,LONG id,const BaseContainer &data);
	Bool            (*SimpleListView_GetItem      )(_SimpleListView *lv,LONG id,BaseContainer *data);
	LONG            (*SimpleListView_GetItemCount )(_SimpleListView *lv);
	Bool            (*SimpleListView_GetItemLine  )(_SimpleListView *lv,LONG num,LONG *id,BaseContainer *data);
	Bool            (*SimpleListView_RemoveItem   )(_SimpleListView *lv,LONG id);
	LONG            (*SimpleListView_GetSelection )(_SimpleListView *lv,BaseSelect *selection);
	Bool            (*SimpleListView_SetSelection )(_SimpleListView *lv,BaseSelect *selection);

	LONG            (*SimpleListView_GetProperty  )(_SimpleListView *lv,LONG id);
	Bool            (*SimpleListView_SetProperty  )(_SimpleListView *lv,LONG id,LONG val);

	Bool						(*IsHotkeyDown                )(CUserArea *cu, LONG id);
	Bool						(*HasFocus										)(CUserArea *cu);

	void						(*MouseDragStart							)(CUserArea *cu,LONG Button,Real mx,Real my,LONG flag);
	LONG						(*MouseDrag										)(CUserArea *cu,Real *mx,Real *my,BaseContainer *channels);
	LONG						(*MouseDragEnd								)(CUserArea *cu);
};

struct C4D_Parser
{
	Parser*					(*Alloc								)(void);
	void						(*Free								)(Parser *pr);
	Bool						(*AddVar							)(Parser *pr, const String *str, Real *value);
	Bool						(*Eval								)(Parser *pr, const String *str, LONG *error,Real *res,LONG unit,LONG angletype,LONG basis);
};

struct C4D_Resource
{
	LocalResource*	(*Alloc								)(const Filename *path);
	void						(*Free                )(LocalResource *lr);
	String*					(*LoadStringEx        )(LocalResource *lr,LONG id);
	LocalResource*  (*GetCinemaResource   )(void);
	const String&		(*LoadString          )(LocalResource *lr,LONG id);
};

struct C4D_Atom
{
	Atom*						(Atom::*GetClone							)(LONG flags, AliasTrans *trn);
	Bool						(Atom::*CopyTo								)(Atom *dst, LONG flags, AliasTrans *trn);
	LONG						(Atom::*GetType								)(void);
	Bool						(Atom::*IsInstanceOf					)(LONG id);
	Bool						(Atom::*Message								)(LONG type, void *data);
	Bool						(Atom::*MultiMessage					)(LONG flags, LONG type, void *data);
	Bool            (Atom::*GetDescription				)(Description &res,LONG flags);
	Bool            (Atom::*GetParameter					)(const DescID &id,GeData &t_data,LONG flags);
	Bool            (Atom::*SetParameter					)(const DescID &id,const GeData &t_data,LONG flags);
	DynamicDescription*		(Atom::*GetDynamicDescription)();

	GeListNode*			(GeListNode::*GetNext					)(void) const;
	GeListNode*			(GeListNode::*GetPred					)(void) const;
	GeListNode*			(GeListNode::*GetUp						)(void) const;
	GeListNode*			(GeListNode::*GetDown					)(void) const;
	GeListNode*			(GeListNode::*GetDownLast			)(void) const;
	void						(GeListNode::*InsertBefore		)(GeListNode *bl);
	void						(GeListNode::*InsertAfter			)(GeListNode *bl);
	void						(GeListNode::*InsertUnder			)(GeListNode *bl);
	void						(GeListNode::*InsertUnderLast	)(GeListNode *bl);
	void						(GeListNode::*Remove					)(void);
	GeListHead*			(GeListNode::*GetListHead			)(void);
	BaseDocument*		(GeListNode::*GetDocument			)(void) const;

	GeListNode*			(GeListHead::*GetFirst				)(void) const;
	GeListNode*			(GeListHead::*GetLast					)(void) const;
	void						(GeListHead::*FlushAll				)(void);
	void						(GeListHead::*InsertFirst			)(GeListNode *bn);
	void						(GeListHead::*InsertLast			)(GeListNode *bn);
	void						(GeListHead::*SetParent				)(GeListNode *parent);
	GeListNode*			(GeListHead::*GetParent				)(void) const;

	BaseList2D*			(BaseList2D::*GetMain					)(void) const;
	const String&   (BaseList2D::*GetName					)(void);
	void						(BaseList2D::*SetName					)(const String &str);
	Bool						(BaseList2D::*TransferGoal		)(BaseList2D *dst);
	Bool						(BaseList2D::*SetAnimatedParameter)(const DescID &id,const GeData &t_data1,const GeData &t_data2,Real mix,LONG flags);
	Bool						(BaseList2D::*GetAnimatedParameter)(const DescID &id,GeData &t_data1,GeData &t_data2,Real &mix,LONG flags);

	// AtomArray
	AtomArray*			(*AtomArrayAlloc							)();
	void						(*AtomArrayFree								)(AtomArray *&obj);
	LONG						(AtomArray::*GetCount					)() const;
	Atom *					(AtomArray::*GetIndex					)(LONG idx) const;
	Bool						(AtomArray::*Append						)(Atom *obj);
	void						(AtomArray::*Flush						)();
	Bool						(AtomArray::*AACopyTo					)(AtomArray *dest) const;

	LONG						(AtomArray::*AAGetUserID			)() const;
	void						(AtomArray::*AASetUserID			)(LONG t_userid);

	void*						(AtomArray::*AAGetUserData		)() const;
	void						(AtomArray::*AASetUserData		)(void *t_userdata);

	LONG						(GeListNode::*GetBranchInfo		)(BranchInfo *info, LONG max);

	Atom*						(AtomArray::*AAGetPreferred		)() const;
	void						(AtomArray::*AASetPreferred		)(Atom *t_preferred);
};

class Coffee;
class VALUE;
class GeData;

typedef GeData CoffeeEditorCallback(BaseList2D *obj, const BaseContainer &msg);
#define COFFEEEDITOR_GETSTRING	'gets'
#define COFFEEEDITOR_SETSTRING	'sets'
#define COFFEEEDITOR_COMPILE		'comp'
	#define COFFEEEDITOR_GETERROR_RES			'resr'
	#define COFFEEEDITOR_GETERROR_STRING	'ress'
	#define COFFEEEDITOR_GETERROR_LINE		'resl'
	#define COFFEEEDITOR_GETERROR_POS			'resp'
#define COFFEEEDITOR_EXECUTE		'exec'

struct C4D_Coffee
{
	Coffee*					(*GeCoffeeAlloc								)();
	void						(*GeCoffeeFree								)(Coffee* &cof);
	Bool						(*GeCoffeeCompileString				)(Coffee* cof, const String& src);
	Bool						(*GeCoffeeCompileFile					)(Coffee* cof, const Filename& file);
	VALUE*					(*GeCoffeeAddGlobalSymbol			)(Coffee* cof, const String& name);
	VALUE*					(*GeCoffeeFindGlobalSymbol		)(Coffee* cof, const String& name);
	Bool						(*GeCoffeeExecute							)(Coffee* cof, VALUE* func, GeData* retval, GeData* arg1, GeData* arg2, GeData* arg3);
	Bool						(*GeCoffeeGeData2Value				)(Coffee* cof, const GeData& src, VALUE* dest);
	Bool						(*GeCoffeeValue2GeData				)(Coffee* cof, VALUE *src, GeData* dest);
	Bool						(*GeCoffeeGetLastError				)(Coffee* cof, String *err_string, LONG *err_line, LONG *err_pos);
	Bool						(*CoffeeEditor_Open						)(BaseList2D *obj,CoffeeEditorCallback *callback);
};

struct C4D_BaseList
{
	LONG						(*GetTypeEx						)(Atom *at);
	LONG						(*GetDiskType					)(Atom *at);
	void						(*GetMarkerEx					)(BaseList2D *bl, ULONG *l1, ULONG *l2);
	GeListNode*			(*NextEx							)(GeListNode *bl);
	GeListNode*			(*PredEx							)(GeListNode *bl);
	void						(*InsertBeforeEx			)(GeListNode *element, GeListNode *bl);
	void						(*InsertAfterEx				)(GeListNode *element, GeListNode *bl);
	void						(*RemoveEx						)(GeListNode *bl);
	void						(*SetAllBits					)(BaseList2D *bl, LONG mask);
	LONG						(*GetAllBits					)(BaseList2D *bl);
	void						(*SetColor						)(BaseList2D *bl, LONG mask);
	LONG						(*GetColor						)(BaseList2D *bl);
	Bool						(*MessageEx						)(Atom *at, LONG type, void *data);
	GeListNode*			(*UpEx								)(GeListNode *bl);
	GeListNode*			(*DownEx							)(GeListNode *bl);
	GeListNode*			(*DownLastEx					)(GeListNode *bl);
	void						(*InsertUnderEx				)(GeListNode *element, GeListNode *bl);
	void						(*InsertUnderLastEx		)(GeListNode *element, GeListNode *bl);
	void						(*Free								)(Atom *at);
	void*						(*GetMainEx						)(BaseList2D *bl);
	Bool						(*Read								)(Atom *at, HyperFile *hf, LONG id, LONG level);
	Bool						(*Write								)(Atom *at, HyperFile *hf);
	Bool						(*ReadObject					)(Atom *bn, HyperFile *hf, Bool readheader);
	Bool						(*WriteObject					)(Atom *bn, HyperFile *hf);
	void						(*GetData							)(BaseList2D *bl, BaseContainer *ct);
	void						(*SetData							)(BaseList2D *bl, const BaseContainer *ct, Bool add);
	BaseContainer*	(*GetDataInstance			)(BaseList2D *bl);

	GeListHead*			(*AllocListHead				)(void);
	GeListNode*			(*AllocListNode				)(LONG bits, LONG *id_array, LONG id_cnt);

	NodeData*				(*GetNodeData					)(GeListNode *bn, LONG index);
	LONG						(*GetNodeID						)(GeListNode *bn, LONG index);
	NODEPLUGIN*			(*RetrieveTable				)(GeListNode *node, LONG index);
	NODEPLUGIN*			(*RetrieveTableX			)(NodeData *node, LONG index);

	GeListNode*			(*GetCustomData				)(GeListNode *bn);
	void						(*SetCustomData				)(GeListNode *bn, GeListNode *custom);
	String					(*GetBubbleHelp				)(BaseList2D *bl);
};

struct C4D_Tag
{
	BaseTag*				(*Alloc								)(LONG type, LONG subtype, LONG count);
	BaseTag*				(*GetCloneEx					)(BaseTag *bt, LONG flags);
	Bool						(*CopyToEx						)(BaseTag *bt, BaseTag *dest, LONG flags);
	LONG						(*GetTagInfoEx				)(BaseTag *bt);
	Bool						(*EditEx							)(BaseTag *bt);
	LONG						(*GetDataCount				)(VariableTag *bt);
	LONG						(*GetDataSize					)(VariableTag *bt);
	void*						(*GetDataAddress			)(VariableTag *bt);
	void						(*SetDataEx						)(BaseTag *tag, BaseContainer *bc);
	void						(*GetDataEx						)(BaseTag *tag, BaseContainer *bc);
	BaseSelect*			(*GetBaseSelect				)(SelectionTag *tag);
	Bool						(*Record							)(StickTextureTag *stt, BaseObject *op, Bool always);
	LONG						(*GetPluginIDEx				)(PluginTag *tag);
	void*						(*GetPluginDataEx			)(PluginTag *tag);
	void						(*SetPluginDataEx			)(PluginTag *tag,void *mem);

	// UVWs
	void						(*UvGet								)(UVWTag *tag, LONG i, UVWStruct *s);
	void						(*UvSet								)(UVWTag *tag, LONG i, UVWStruct *s);
	void						(*UvCpy								)(UVWTag *tag, LONG dst, UVWTag *srctag, LONG src);

	void						(*GetIconEx						)(BaseTag *tag, IconData *dat);
};

struct C4D_Object
{
	BaseObject*			(*Alloc								)(LONG type, LONG subtype);
	SplineObject*		(*AllocSplineObject		)(LONG pcnt, LONG type);
	PluginObject*		(*AllocPluginObjectEx	)(LONG plug_id);
	LONG						(*GetSubTypeEx				)(BaseObject *op);
	LONG						(*GetLayerTypeEx			)(BaseObject *op);
	BaseContainer*	(*GetDataEx						)(BaseObject *op);
	void						(*GetParameterEx			)(BaseObject *op, BaseContainer *data);
	void						(*SetParameterEx			)(BaseObject *op, const BaseContainer *data);
	Real						(*GetVisibility				)(BaseObject *op, Real parent);
	void						(*SetVisibilityEx			)(BaseObject *op, Real p);
	Vector					(*GetPos							)(BaseObject *op);
	void						(*SetPos							)(BaseObject *op, const Vector &v);
	Vector					(*GetScale						)(BaseObject *op);
	void						(*SetScale						)(BaseObject *op, const Vector &v);
	Vector					(*GetRot							)(BaseObject *op);
	void						(*SetRot							)(BaseObject *op, const Vector &v);
	Matrix					(*GetMl								)(BaseObject *op);
	void						(*SetMlEx							)(BaseObject *op, const Matrix &m);
	Matrix					(*GetMg								)(BaseObject *op);
	void						(*SetMgEx							)(BaseObject *op, const Matrix &m);
	Matrix					(*GetMln							)(BaseObject *op);
	Matrix					(*GetMgn							)(BaseObject *op);
	Matrix					(*GetUpMg							)(BaseObject *op);
	Vector					(*GetMp								)(BaseObject *op);
	Vector					(*GetRad							)(BaseObject *op);
	LONG						(*GetMode							)(BaseObject *op, LONG mode);
	void						(*SetMode							)(BaseObject *op, LONG mode, LONG val);
	void						(*GetNameEx						)(BaseObject *op, String *name);
	void						(*SetNameEx						)(BaseObject *op, const String *name);
	BaseTag*				(*GetFirstTag					)(BaseObject *op);
	BaseTag*				(*GetTag							)(BaseObject *op, LONG type, LONG nr);
	void*						(*GetTagData					)(BaseObject *op, LONG type, LONG nr);
	LONG						(*GetTagDataCount			)(BaseObject *op, LONG type);
	void						(*InsertTag						)(BaseObject *op, BaseTag *tp, BaseTag *pred);
	void						(*KillTag							)(BaseObject *op, LONG type, LONG nr);
	BaseTrack*			(*GetFirstTrack				)(BaseList2D *op);
	BaseTrack*			(*GetTrack						)(BaseList2D *op, LONG type);
	void						(*KillAllTracks				)(BaseList2D *op);
	void						(*InsertTrack					)(BaseList2D *op, BaseTrack *track, BaseTrack *pred);
	LONG						(*GetInfo							)(BaseList2D *op);
	Bool						(*Edit								)(BaseList2D *op);
	BaseObject*			(*GetCache						)(BaseObject *op, HierarchyHelp *hh);
	BaseObject*			(*GetDeformCache			)(BaseObject *op);
	LineObject*			(*GetIsoparm					)(BaseObject *op);
	Bool						(*CopyToEx						)(BaseObject *op, BaseObject *dest, LONG flags);
	Bool						(*CopyTagsToEx				)(BaseObject *op, BaseObject *dest, LONG visible, LONG variable, LONG hierarchical);
	BaseObject*			(*GetCloneEx					)(BaseObject *op, LONG flags);
	Bool						(*IsDirty							)(BaseObject *op, LONG flags);
	void						(*SetDirty						)(BaseObject *op, LONG flags);
	Bool						(*CheckCache					)(BaseObject *op, HierarchyHelp *hh);
	void						(*SetIsoparm					)(BaseObject *op, LineObject *l);
	BaseObject*			(*GenPrimitive				)(BaseDocument *doc, LONG type, const BaseContainer *bc, Real lod, Bool isoparm, BaseThread *bt);
	BaseObject*			(*GenSplinePrimitive	)(BaseDocument *doc, LONG type, const BaseContainer *bc, Real lod, BaseThread *bt);
	LONG						(*GetPluginIDEx				)(PluginObject *op);
	void*						(*GetPluginDataEx			)(PluginObject *op);
	void						(*SetPluginDataEx			)(PluginObject *op,void *mem);
	Bool						(*IsAddictedEx				)(BaseObject *op,BaseDocument *doc);
	Bool						(*GetActiveDependenceEx)(BaseObject *op);
	void						(*SetActiveDependenceEx)(BaseObject *op, Bool on);
	void						(*NewDependenceList		)(PluginObject *op);
	Bool						(*CmpDependenceList		)(PluginObject *op);
	void						(*TouchDependenceList	)(PluginObject *op);
	void						(*AddDependence				)(PluginObject *op,HierarchyHelp *hh, BaseObject *pp);
	Bool						(*AddTexture					)(PluginObject *op, const Filename *fn, RootTextureString *priv);
	BaseObject*			(*GetHierarchyCloneEx	)(PluginObject *op,HierarchyHelp *hh, BaseObject *pp, LONG flags, Bool *dirty);
	BaseObject*			(*GetVirtualLineObject)(BaseObject *op, HierarchyHelp *hh, const Matrix &mloc, Bool keep_spline, Bool recurse, Matrix *mres, Bool *dirty);
	void						(*Touch								)(BaseObject *op);

	// point object
	BaseSelect*			(*PoGetPointS					)(PointObject *op);
	BaseSelect*			(*PoGetPointH					)(PointObject *op);
	Bool						(*PoResizeObject			)(PointObject *op, LONG pcnt);
	Real*						(*PoCalcVertexMap			)(PointObject *op, BaseObject *modifier);

	// line object
	Bool						(*LoResizeObject			)(LineObject *op, LONG pcnt, LONG scnt);

	// polygon object
	BaseSelect*			(*PyGetPolygonS				)(PolygonObject *op);
	BaseSelect*			(*PyGetPolygonH				)(PolygonObject *op);
	Bool						(*PyResizeObject			)(PolygonObject *op, LONG pcnt, LONG vcnt);

	// spline object
	Vector					(*SpGetSplinePoint		)(SplineObject *op, Real t, LONG segment, Vector *padr);
	Vector					(*SpGetSplineTangent	)(SplineObject *op, Real t, LONG segment, Vector *padr);
	Bool						(*SpInitLength				)(SplineObject *op, LONG segment, Vector *padr);
	void						(*SpFreeLength				)(SplineObject *op);
	Real						(*SpUniformToNatural	)(SplineObject *op, Real t);
	Real						(*SpGetLength					)(SplineObject *op);
	Real						(*SpGetSegmentLength	)(SplineObject *op, LONG a, LONG b);
	LineObject*			(*SpGetLineObject			)(SplineObject *op, BaseDocument *doc, Real lod, BaseThread *thread);
	SplineObject*		(*SpGetRealSpline			)(BaseObject *op);
	Bool						(*SpResizeObject			)(SplineObject *op, LONG pcnt, LONG scnt);

	// particle object
	LONG						(*PrGetCount					)(ParticleObject *op);
	Real						(*PrGetLifetime				)(ParticleObject *op);
	Particle*				(*PrGetParticle				)(ParticleObject *op, ParticleTag *pt, LONG i);
	Bool						(*PrIsMatrixAvailable	)(ParticleObject *op);
	ParticleDetails*(*PrGetParticleDetails)(BaseDocument *doc, ParticleObject *op);

	// camera object
	LONG						(*CoGetProjection			)(BaseObject *op);
	Real						(*CoGetFocus					)(BaseObject *op);
	Real						(*CoGetZoom						)(BaseObject *op);
	Vector					(*CoGetOffset					)(BaseObject *op);
	Real						(*CoGetAperture				)(BaseObject *op);
	Bool						(*CoSetProjection			)(BaseObject *op, LONG projection);
	Bool						(*CoSetFocus					)(BaseObject *op, Real v);
	Bool						(*CoSetZoom						)(BaseObject *op, Real v);
	Bool						(*CoSetOffset					)(BaseObject *op, const Vector &offset);
	Bool						(*CoSetAperture				)(BaseObject *op, Real v);

	// object safety
	ObjectSafety*		(*OsAlloc							)(BaseObject *op);
	void						(*OsFree							)(ObjectSafety *os, Bool restore);

	// triangulation
	Bool						(*Triangulate					)(Vector *padr, LONG pcnt, Polygon **vadr, LONG *vcnt);
	PolygonObject*	(*TriangulateLine			)(LineObject *op, Real regular, BaseThread *bt);
	SplineObject*		(*FitCurve						)(Vector *padr, LONG pcnt, Real error, BaseThread *bt);

	// uv stuff
	UVWTag*					(*GenerateUVW					)(BaseObject *op, const Matrix &opmg, TextureTag *tp, const Matrix &texopmg, BaseView *view);

	void						(*GetIcon							)(BaseList2D *op, IconData *dat);

	ULONG						(*GetDirty						)(BaseObject *op, LONG flags);

	Bool						(*TriangulateStandard )(Vector *padr, LONG pcnt, LONG *list, LONG lcnt, Polygon *&vadr, LONG &vcnt, BaseThread *thread);
	Bool						(*TriangulateRegular	)(Vector *pinp, LONG pinp_cnt, LONG *list, LONG lcnt, Vector *&padr, LONG &pcnt, Polygon *&vadr, LONG &vcnt, Real regular_width, BaseThread *thread);

	Bool						(*SpSetDefaultCoeff		)(SplineObject *op);
	BaseObject*			(*GenerateText				)(BaseContainer *cp, BaseThread *bt, Bool separate);

	BaseSelect*			(*PyGetEdgeS					)(PolygonObject *op);
	BaseSelect*			(*PyGetEdgeH					)(PolygonObject *op);
	void						(*GetColorProperties	)(BaseObject *op, ObjectColorProperties *co);
	void						(*SetColorProperties	)(BaseObject *op, ObjectColorProperties *co);

	void						(*InsertTrackLast			)(BaseList2D *op, BaseTrack *track);
	BaseTrack*			(*FindTrack						)(BaseList2D *op, const DescID &id);
	Bool						(*CopyTagsTo					)(BaseObject *op, BaseObject *dest, LONG visible, LONG variable, LONG hierarchical, AliasTrans *trans);
	BaseObject*			(*GetHierarchyClone		)(PluginObject *op,HierarchyHelp *hh, BaseObject *pp, LONG flags, Bool *dirty, AliasTrans *trans);

	BaseObject*			(*GetCacheParent			)(BaseObject *op);
	Bool						(*CheckDisplayFilter	)(BaseObject *op, LONG flags);

	void						(*SetMl								)(BaseObject *op, const Matrix &m, Bool force);
	void						(*SetMg								)(BaseObject *op, const Matrix &m, Bool force);
	BaseSelect*			(*PyGetPhongBreak			)(PolygonObject *op);

	LONG						(*GetUniqueIP					)(BaseObject *op);
	void						(*SetUniqueIP					)(BaseObject *op, LONG ip);
};

struct C4D_Document
{
	// render data
	RenderData*			(*RdAlloc							)(void);
	void						(*RdGetDataEx					)(RenderData *rd, BaseContainer *bc);
	void						(*RdSetDataEx					)(RenderData *rd, BaseContainer *bc);

	// document
	BaseDocument*		(*Alloc								)(void);
	Bool						(*CopyToEx						)(BaseDocument *src, BaseDocument *dst, LONG flags);
	void						(*FlushAll						)(BaseDocument *doc);
	void						(*GetData							)(BaseDocument *doc, LONG type, BaseContainer *bc);
	void						(*SetData							)(BaseDocument *doc, LONG type, const BaseContainer *bc);
	BaseObject*			(*GetFirstObject			)(BaseDocument *doc);
	BaseMaterial*		(*GetFirstMaterial		)(BaseDocument *doc);
	RenderData*			(*GetFirstRenderData	)(BaseDocument *doc);
	void						(*InsertRenderData		)(BaseDocument *doc, RenderData *rd, RenderData *pred);
	void						(*InsertMaterial			)(BaseDocument *doc, BaseMaterial *mat, BaseMaterial *pred, Bool checknames);
	void						(*InsertObject				)(BaseDocument *doc, BaseObject *op, BaseObject *parent, BaseObject *pred, Bool checknames);
	RenderData*			(*GetActiveRenderData	)(BaseDocument *doc);
	BaseObject*			(*GetActiveObject			)(BaseDocument *doc);
	BaseMaterial*		(*GetActiveMaterial		)(BaseDocument *doc);
	BaseTag*				(*GetActiveTag				)(BaseDocument *doc, BaseObject *active);
	void						(*SetActiveObjectEx		)(BaseDocument *doc, BaseObject *op);
	void						(*SetActiveTagEx			)(BaseDocument *doc, BaseObject *op, BaseTag *ta);
	void						(*SetActiveMaterialEx	)(BaseDocument *doc, BaseMaterial	*mp);
	void						(*SetActiveRenderData	)(BaseDocument *doc, RenderData *rd);
	BaseObject*			(*GetHighest					)(BaseDocument *doc, LONG type, Bool editor);
	BaseMaterial*		(*SearchMaterial			)(BaseDocument *doc, const String *str, Bool inc);
	BaseObject*			(*SearchObject				)(BaseDocument *doc, const String *str, Bool inc);
	Bool						(*StartUndo						)(BaseDocument *doc);
	Bool						(*EndUndo							)(BaseDocument *doc);
	Bool						(*AddUndo							)(BaseDocument *doc, LONG type, void *data);
	Bool						(*DoUndo							)(BaseDocument *doc);
	Bool						(*DoRedo							)(BaseDocument *doc);
	void						(*AnimateDocumentEx		)(BaseDocument *doc, LONG flags);
	void						(*AnimateObject				)(BaseDocument *doc, BaseList2D *op, const BaseTime &time, LONG flags);
	BaseDraw*				(*GetActiveBaseDraw		)(BaseDocument *doc);
	BaseDraw*				(*GetRenderBaseDraw		)(BaseDocument *doc);
	BaseDraw*				(*GetBaseDraw					)(BaseDocument *doc, LONG num);
	LONG						(*GetSplinePlane			)(BaseDocument *doc);

	// hierarchy help
	Real						(*HhGetLOD						)(HierarchyHelp *hh);
	LONG						(*HhGetVFlags					)(HierarchyHelp *hh);
	BaseThread*			(*HhGetThread					)(HierarchyHelp *hh);
	BaseDocument*		(*HhGetDocument				)(HierarchyHelp *hh);
	Matrix					(*HhGetMg							)(HierarchyHelp *hh);
	void						(*HhAddVFlags					)(HierarchyHelp *hh, LONG mask);

	// hierarchy
	Bool						(*RunHierarchy				)(void *main, BaseDocument *doc, Bool spheres, Real lod, LONG flags, void *startdata, BaseThread *bt, HierarchyAlloc *ha, HierarchyFree *hf, HierarchyCopyTo *hc, HierarchyDo *hd);

	Bool						(*AnimateDocument     )(BaseDocument *doc,BaseThread *bt,Bool doexpressions,Bool doanim);
	PluginSceneHook*(*FindSceneHook				)(BaseDocument *doc,LONG id);

	void						(BaseDocument::*SetActiveObject		)(BaseObject *op,LONG mode);
	void						(BaseDocument::*GetActiveObjects	)(AtomArray &selection,Bool childs) const;
	void						(BaseDocument::*GetActiveTags			)(AtomArray &selection) const;

	void						(*PrAdd								)(PriorityList *list, GeListNode *node, LONG priority, LONG flags);
	BaseObject*			(*GetHelperAxis				)(BaseDocument *doc);
	PluginVideoPost*(*RdGetFirstVideoPost	)(RenderData *rd);
	void						(*RdInsertVideoPost		)(RenderData *rd, PluginVideoPost *pvp, PluginVideoPost *pred);
	void						(BaseDocument::*GetActiveMaterials)(AtomArray &selection) const;

	Bool						(*SoundCommand				)(BaseDocument *doc, LONG command);
	void						(*SetRewind						)(BaseDocument *doc, LONG flags);

	void						(BaseDocument::*SetActiveTag			)(BaseTag *op,LONG mode);
	void						(BaseDocument::*SetActiveMaterial	)(BaseMaterial *mat,LONG mode);

	PluginVideoPost*(*VpAlloc							)(LONG type);

	LONG						(*MgGetCount						)(BaseDocument *doc);
	BaseContainer*	(*MgAdd									)(BaseDocument *doc,const BaseContainer &g);
	Bool						(*MgRemove							)(BaseDocument *doc,LONG id);
	BaseContainer*	(*MgGetIndex						)(BaseDocument *doc,LONG i);
	BaseContainer*	(*MgGetID								)(BaseDocument *doc,LONG id);
	Bool						(*MgIsVisible						)(BaseDocument *doc,BaseMaterial *mat);
};

#ifndef __GE_SPINLOCK
#define __GE_SPINLOCK

	typedef volatile LONG	GE_SPINLOCK;

	struct GE_RWSPINLOCK
	{
		GE_RWSPINLOCK()	{lock = 0; count = 0;}

		GE_SPINLOCK			lock;
		volatile LONG		count;
	};

#endif

struct C4D_Thread
{
	BaseThread*			(*Alloc								)(ThreadMain *tm, ThreadTest *tt, void *data);
	void						(*Free								)(BaseThread *bt);
	Bool						(*TestBreak						)(BaseThread *bt);
	Bool						(*TestBaseBreak				)(BaseThread *bt);
	Bool						(*IsRunning						)(BaseThread *bt);
	Bool						(*Start								)(BaseThread *bt, Bool back, Bool pri);
	void						(*End									)(BaseThread *bt);
	void						(*ThreadLock					)(void);
	void						(*ThreadUnLock				)(void);
	LONG						(*GetCPUCount					)(void);
	MPBaseThread*		(*MPAlloc							)(BaseThread *parent, LONG count, ThreadMain *tm, ThreadTest *tt, void **data);
	void						(*MPFree							)(MPBaseThread *mp);
	BaseThread*			(*MPGetThread					)(MPBaseThread *mp, LONG i);
	void*						(*MPWaitForNextFree		)(MPBaseThread *mp);
	void						(*MPWait							)(MPBaseThread *mp);
	void						(*MPEnd								)(MPBaseThread *mp);
	Semaphore*			(*SMAlloc							)(void);
	void						(*SMFree							)(Semaphore *sm);
	Bool						(*SMLock							)(Semaphore *sm);
	Bool						(*SMLockAndWait				)(Semaphore *sm, BaseThread *bt);
	void						(*SMUnLock						)(Semaphore *sm);
	void						(*Wait								)(BaseThread *bt, Bool checkevents);

	BaseThread			*NoThread;

	void						(*SpinLock						)(GE_SPINLOCK *lock);
	void						(*SpinUnlock					)(GE_SPINLOCK *lock);
	void						(*SpinReadLock				)(GE_RWSPINLOCK *rwlock);
	void						(*SpinReadUnlock			)(GE_RWSPINLOCK *rwlock);
	void						(*SpinWriteLock				)(GE_RWSPINLOCK *rwlock);
	void						(*SpinWriteUnlock			)(GE_RWSPINLOCK *rwlock);

	LONG						(*Identify						)(BaseThread *bt);
};

struct C4D_Material
{
	BaseMaterial*		(*Alloc								)(LONG type, LONG shader_id);
	LONG						(*GetPluginIDEx				)(PluginMaterial *mat);
	void*						(*GetPluginDataEx			)(PluginMaterial *mat);
	void						(*GetNameEx						)(BaseMaterial *mat, String *name);
	void						(*SetNameEx						)(BaseMaterial *mat, const String *name);

	void						(*Update							)(BaseMaterial *mat, LONG preview, Bool rttm);
	BaseMaterial*		(*GetCloneEx					)(BaseMaterial *bm, LONG flags);
	Bool						(*CopyToEx						)(BaseMaterial *bm, BaseMaterial *dest, LONG flags);
	Bool						(*EditEx							)(BaseMaterial *bm);
	void						(*SetDataEx						)(BaseMaterial *bm, BaseContainer *bc);
	void						(*GetDataEx						)(BaseMaterial *bm, BaseContainer *bc);
	BaseChannel*		(*GetChannel					)(BaseMaterial *bm, LONG id);
	Bool						(*GetChannelState			)(Material *mat, LONG channel);
	void						(*SetChannelState			)(Material *mat, LONG channel, Bool state);
	Bool						(*Compare							)(BaseMaterial *m1, BaseMaterial *m2);

	VOLUMESHADER*		(*GetShaderEx					)(PluginMaterial *mat);
	BaseBitmap*			(*GetPreview					)(BaseMaterial *bm, LONG flags);
};

struct C4D_Texture
{
	Vector					(*GetPos							)(BaseList2D *tag);
	Vector					(*GetScale						)(BaseList2D *tag);
	Vector					(*GetRot							)(BaseList2D *tag);
	Matrix					(*GetMl								)(BaseList2D *tag);
	Matrix					(*GetMln							)(BaseList2D *tag);
	void						(*SetPos							)(BaseList2D *tag, const Vector &v);
	void						(*SetScale						)(BaseList2D *tag, const Vector &v);
	void						(*SetRot							)(BaseList2D *tag, const Vector &v);
	void						(*SetMl								)(BaseList2D *tag, const Matrix &m);

	BaseMaterial*		(*GetMaterial					)(BaseList2D *tag);
	void						(*SetMaterial					)(BaseList2D *tag, BaseMaterial *mat);

	BaseMaterial*		(*GetSecondMaterialEx	)(TextureTag *tag, Real *fade);
	void						(*SetSecondMaterialEx	)(TextureTag *tag, BaseMaterial *mat, Real fade);

	BaseMaterial*   (*GetInterpolatedMaterialEx)(BaseDocument *doc, TextureTag *tag);
};

struct C4D_BaseSelect
{
	BaseSelect*			(*Alloc								)(void);
	void						(*Free								)(BaseSelect *bs);
	void						(*FlushAll						)(BaseSelect *bs);
	LONG						(*GetCount						)(BaseSelect *bs);
	LONG						(*GetSegments					)(BaseSelect *bs);
	Bool						(*Select							)(BaseSelect *bs, LONG num);
	Bool						(*SelectAll						)(BaseSelect *bs, LONG min, LONG max);
	Bool						(*Deselect						)(BaseSelect *bs, LONG num);
	Bool						(*DeselectAll					)(BaseSelect *bs);
	Bool						(*Toggle							)(BaseSelect *bs, LONG num);
	Bool						(*ToggleAll						)(BaseSelect *bs, LONG min, LONG max);
	Bool						(*GetRange						)(BaseSelect *bs, LONG seg, LONG *a, LONG *b);
	Bool						(*IsSelected					)(BaseSelect *bs, LONG num);
	Bool						(*CopyTo							)(BaseSelect *bs, BaseSelect *dest);
	BaseSelect*			(*GetClone						)(BaseSelect *bs);
	Bool						(*FromArray						)(BaseSelect *bs, UCHAR *selection, LONG count);
	UCHAR*					(*ToArray							)(BaseSelect *bs, LONG count);
};

struct C4D_Key
{
	BaseKey*				(*Alloc								)(LONG type, LONG plugid);
	BaseKey*				(*GetCloneEx					)(BaseKey *bk, LONG flags);
	Bool						(*CopyToEx						)(BaseKey *bk, BaseKey *dest, LONG flags);
	Bool						(*EditEx							)(BaseKey *bk);
	BaseTime				(*GetTime							)(BaseKey *bk);
	void						(*SetTime							)(BaseKey *bk, const BaseTime &time);
	void						(*GetDataEx						)(BaseKey *bk, BaseContainer *ct);
	void						(*SetDataEx						)(BaseKey *bk, const BaseContainer *ct);
	void						(*SetPEx					    )(BaseKey *bk, const Vector &v);
	void						(*SetVLEx					    )(BaseKey *bk, const Vector &v);
	void						(*SetVREx					    )(BaseKey *bk, const Vector &v);
	Vector					(*GetPEx					    )(BaseKey *bk);
	Vector					(*GetVLEx					    )(BaseKey *bk);
	Vector					(*GetVREx					    )(BaseKey *bk);
	void						(*SoftTangentsEx			)(BaseKey *bk, BaseDocument *doc, LONG component);
	VariableTag*		(*GetPointTag					)(PLAKey *bk);
	VariableTag*		(*GetHermiteTag				)(PLAKey *bk);
	LONG						(*GetPluginIDEx				)(PluginKey *op);
	void*						(*GetPluginDataEx			)(PluginKey *op);
	void						(*SetPluginDataEx			)(PluginKey *op,void *mem);
	Bool						(*FillKey             )(BaseKey *bk);
	AnimValue*      (*GetKeyValue         )(BaseKey *bk);
};

struct C4D_Sequence
{
	BaseSequence*		(*Alloc								)(LONG type, LONG plugid);
	BaseSequence*		(*GetCloneEx					)(BaseSequence *bs, LONG flags);
	Bool						(*CopyToEx						)(BaseSequence *bs, BaseSequence *dest, LONG flags);
	Bool						(*EditEx							)(BaseSequence *bs);
	BaseTime				(*GetT1								)(BaseSequence *bs);
	void						(*SetT1								)(BaseSequence *bs, const BaseTime &time);
	BaseTime				(*GetT2								)(BaseSequence *bs);
	void						(*SetT2								)(BaseSequence *bs, const BaseTime &time);
	BaseTime				(*GetT3								)(BaseSequence *bs);
	void						(*SetT3								)(BaseSequence *bs, const BaseTime &time);
	Bool						(*GetSoft							)(BaseSequence *bs);
	void						(*SetSoft							)(BaseSequence *bs, Bool b);
	void						(*FlushAllKeys				)(BaseSequence *bs);
	void						(*FlushAllTimeKeysEx	)(BaseSequence *bs);
	LONG						(*GetKeyCount					)(BaseSequence *bs);
	LONG						(*GetTimeKeyCountEx		)(BaseSequence *bs);
	BaseKey*				(*FindKey							)(BaseSequence *bs, const BaseTime &time);
	BaseTime				(*GetLeft							)(BaseSequence *bs);
	BaseTime				(*GetRight						)(BaseSequence *bs);
	LONG						(*GetTimeModeEx				)(BaseSequence *bs);
	void						(*SetTimeModeEx				)(BaseSequence *bs, LONG l);
	Bool						(*GetLeftInfluence		)(BaseSequence *bs);
	void						(*SetLeftInfluence		)(BaseSequence *bs, Bool b);
	Bool						(*GetRightInfluence		)(BaseSequence *bs);
	void						(*SetRightInfluence		)(BaseSequence *bs, Bool b);
	Real						(*GetV0Ex							)(BaseSequence *bs);
	void						(*SetV0Ex							)(BaseSequence *bs, Real v0);
	Real						(*GetS0Ex							)(BaseSequence *bs);
	void						(*SetS0Ex							)(BaseSequence *bs, Real s0);
	BaseKey*				(*GetFirstKey					)(BaseSequence *bs);
	BaseKey*				(*GetFirstTimeKeyEx		)(BaseSequence *bs);
	Bool						(*InsertKey						)(BaseSequence *bs, BaseKey *bk);
	Bool						(*InsertTimeKeyEx			)(BaseSequence *bs, BaseKey *bk);
	void						(*GetNameEx						)(BaseSequence *bk, String *ct);
	void						(*SetNameEx						)(BaseSequence *bk, const String *ct);
	BaseObject*			(*GetFirstObjectEx		)(BaseSequence *bk);
	void						(*InsertObjectEx			)(BaseSequence *bk, BaseObject *op, BaseObject *parent, BaseObject *prev);
	BaseSound*			(*GetSound						)(SoundSequence *ss);
	void						(*SetSound						)(SoundSequence *ss, BaseSound *bs);
	LONG						(*GetPluginIDEx				)(PluginSequence *op);
	void*						(*GetPluginDataEx			)(PluginSequence *op);
	void						(*SetPluginDataEx			)(PluginSequence *op,void *mem);
	void						(*GetDataEx						)(BaseSequence *bk, BaseContainer *ct);
	void						(*SetDataEx						)(BaseSequence *bk, const BaseContainer *ct);
};

struct C4D_Track
{
	BaseTrack*			(*Alloc								)(LONG type, LONG plugid);
	BaseTrack*			(*GetCloneEx					)(BaseTrack *bt, LONG flags);
	Bool						(*CopyToEx						)(BaseTrack *bt, BaseTrack *dest, LONG flags);
	void						(*GetNameEx						)(BaseTrack *bt, String *st);
	BaseSequence*		(*GetFirstSequence		)(BaseTrack *bt);
	Bool						(*InsertSequence			)(BaseTrack *bt, BaseSequence *bs, Bool check);
	Bool						(*AnimateObject				)(BaseTrack *bt, BaseDocument *doc, BaseList2D *op, const BaseTime &time, LONG flags, void *data);
	BaseSequence*		(*FindSequence				)(BaseTrack *bt, const BaseTime &time);
	LONG						(*GetPluginIDEx				)(PluginTrack *op);
	void*						(*GetPluginDataEx			)(PluginTrack *op);
	void						(*SetPluginDataEx			)(PluginTrack *op,void *mem);
	void						(*GetDataEx						)(BaseTrack *bk, BaseContainer *ct);
	void						(*SetDataEx						)(BaseTrack *bk, const BaseContainer *ct);
	BaseTrack*		  (*AllocValueTrack     )(Atom *op, const DescID &id);
	BaseTrack*		  (*AllocDataTrack      )(Atom *op, const DescID &id);
	BaseTrack*		  (*AllocTimeTrack      )();
	const DescID& 	(*GetDescriptionID    )(BaseTrack *bt);
	BaseSequence*		(*AutoAddSequence			)(BaseTrack *bt, BaseDocument *doc, const BaseTime &time);
};

struct C4D_BaseSound
{
	BaseSound*			(*Alloc								)(void);
	void						(*Free								)(BaseSound *bs);
	BaseSound*			(*GetClone						)(BaseSound *bs);
	Bool						(*CopyTo							)(BaseSound *bs, BaseSound *dest);
	Bool						(*Init								)(BaseSound *bs, LONG samples, LONG fmode, Bool stereo, Bool b16);
	void						(*FlushAll						)(BaseSound *bs);
	Bool						(*Load								)(BaseSound *bs, const Filename *fn);
	Bool						(*Save								)(BaseSound *bs, const Filename *fn);
	void						(*GetSoundInfo				)(BaseSound *bs, Bool *stereo, Bool *b16, LONG *frequency, LONG *samples, BaseTime *length);
	void						(*GetSample						)(BaseSound *bs, LONG i, SData *data);
	void						(*SetSample						)(BaseSound *bs, LONG i, SData *data);
	BaseBitmap*			(*GetBitmap						)(BaseSound *bs, LONG width, LONG height, const BaseTime &start, const BaseTime &stop);
	BaseKey*				(*GetFirstMarker			)(BaseSound *bs);
	Bool						(*InsertMarker				)(BaseSound *bs, BaseKey *mk, BaseKey *pred);
	CHAR*						(*GetRAW							)(BaseSound *bs);
};

struct C4D_BaseDraw
{
	// basedraw
	Bool						(*HasCameraLink				)(BaseDraw *bd);
	void						(*SetSceneCamera			)(BaseDraw *bd, BaseObject *op);
	BaseObject*			(*GetSceneCameraEx		)(BaseDraw *bd);
	BaseObject*			(*GetEditorCamera			)(BaseDraw *bd);
	Vector					(*GetObjectColorEx		)(BaseDraw *bd, BaseObject *op);
	Vector					(*CheckColor					)(BaseDraw *bd, const Vector &col);
	Bool						(*ZBufAvailable				)(BaseDraw *bd);
	BaseBitmap*			(*GetBitmapEx					)(BaseDraw *bd);
	void						(*SetTransparency			)(BaseDraw *bd, LONG trans);
	LONG						(*GetTransparency			)(BaseDraw *bd);
	Bool						(*PointInRange				)(BaseDraw *bd, const Vector &p, LONG x, LONG y);
	void						(*SetPen							)(BaseDraw *bd, const Vector &col);
	Real						(*SimpleShade					)(BaseDraw *bd, const Vector &p, const Vector &n);
	void						(*Begin2DEx						)(BaseDraw *bd);
	void						(*End2DEx							)(BaseDraw *bd);
	void						(*Point2D							)(BaseDraw *bd, const Vector &p);
	void						(*Line2D							)(BaseDraw *bd, const Vector &p1, const Vector &p2); // draw line with 2D clipping
	void						(*Handle2D						)(BaseDraw *bd, const Vector &p, LONG type);
	void						(*Circle2D						)(BaseDraw *bd, LONG mx, LONG my, Real rad);
	void						(*LineCSEx						)(BaseDraw *bd, const Vector &p1, const Vector &p2, Bool clip2d, Bool clipz);
	void						(*Point3D							)(BaseDraw *bd, const Vector &p);
	void						(*Line3D							)(BaseDraw *bd, const Vector &p1, const Vector &p2);
	void						(*Handle3D						)(BaseDraw *bd, const Vector &p, LONG type);
	void						(*Circle3D						)(BaseDraw *bd, const Matrix &m);
	void						(*Box3D								)(BaseDraw *bd, const Matrix &m, Real size, const Vector &col);
	void						(*Polygon3D						)(BaseDraw *bd, Vector *p, Vector *f, Bool quad);
	void						(*PolygonObject				)(BaseDraw *bd, BaseDrawHelp *bh, PolygonObject *op, LONG drawpolyflags);
	void						(*GetDataEx						)(BaseDraw *bd, BaseContainer *bc);

	// basedraw help
	BaseDocument*		(*BbGetDocument				)(BaseDrawHelp *bb);
	BaseTag*				(*BbGetActiveTag			)(BaseDrawHelp *bb);
	Matrix					(*BbGetMg							)(BaseDrawHelp *bb);
	void						(*BbGetDisplay				)(BaseDrawHelp *bb, BaseContainer *bc);

	BaseObject*			(*GetSceneCamera			)(BaseDraw *bd, BaseDocument *doc);
	void						(*LineCS							)(BaseDraw *bd, const Vector &p1, const Vector &p2, Bool clip2d, Bool clipz,Bool offset);
	Vector					(*GetObjectColor			)(BaseDraw *bd, BaseObject *op, BaseDrawHelp *bh);
};

struct C4D_BaseView
{
	void						(*GetFrame						)(BaseView *bv, LONG *cl, LONG *ct, LONG *cr, LONG *cb);
	void						(*GetSafeFrame				)(BaseView *bv, LONG *from, LONG *to, LONG *horizontal);
	void						(*GetParameter				)(BaseView *bv, Vector *offset, Vector *scale, Vector *scale_z);
	Matrix					(*GetMg								)(BaseView *bv);
	Matrix					(*GetMi								)(BaseView *bv);
	LONG						(*GetProjection				)(BaseView *bv);
	Bool						(*TestPoint						)(BaseView *bv, Real x, Real y);
	Bool						(*TestPointZ					)(BaseView *bv, const Vector &p);
	Bool						(*TestClipping3D			)(BaseView *bv, const Vector &mp, const Vector &rad, const Matrix &mg, Bool *clip2d, Bool *clipz);
	Bool						(*ClipLine2D					)(BaseView *bv, Vector *p1, Vector *p2);
	Bool						(*ClipLineZ						)(BaseView *bv, Vector *p1, Vector *p2);
	Vector					(*WS									)(BaseView *bv, const Vector &p);
	Vector					(*SW									)(BaseView *bv, const Vector &p);
	Vector					(*SW_R								)(BaseView *bv, Real x, Real y, const Vector &wp);
	Vector					(*WC									)(BaseView *bv, const Vector &p);
	Vector					(*CW									)(BaseView *bv, const Vector &p);
	Vector					(*SC									)(BaseView *bv, const Vector &p);
	Vector					(*CS									)(BaseView *bv, const Vector &p, Bool z_inverse);
	Vector					(*WC_V								)(BaseView *bv, const Vector &v);
	Vector					(*CW_V								)(BaseView *bv, const Vector &v);
	Bool						(*BackfaceCulling			)(BaseView *bv, const Vector &n, const Vector &p);
	Bool						(*ZSensitive					)(BaseView *bv);
};

struct C4D_Pool
{
	MemoryPool*			(*Alloc								)(LONG block_size);
	void						(*Free								)(MemoryPool *pool);
	void*						(*AllocElement				)(MemoryPool *pool, LONG size, Bool clear);
	void						(*FreeElement					)(MemoryPool *pool, void *mem, LONG size);
	void*						(*AllocElementS				)(MemoryPool *pool, LONG size, Bool clear);
	void						(*FreeElementS				)(MemoryPool *pool, void *mem);
};

struct C4D_General
{
	void*						(*AllocEx							)(LONG size);
	void						(*Free								)(void *data);
	void						(*Print								)(const String *str);

	Bool						(*FExist							)(const Filename *name, Bool isdir);
	Bool						(*SearchFile					)(const Filename *directory, const Filename *name, Filename *found);
	Bool						(*FKill								)(const Filename *name, Bool isdir);
	Bool						(*FCopyFile						)(const Filename *source, const Filename *dest, Bool overwrite);
	Bool						(*FRename							)(const Filename *source, const Filename *dest);
	Bool						(*FCreateDir					)(const Filename *name);
	Bool						(*ExecuteFile					)(const Filename *path);
	Filename*				(*GetStartupPath			)(void);
	Bool						(*ExecuteProgram      )(const Filename *program, const Filename *file);

	void						(*ShowMouse						)(LONG v);
	void						(*GetSysTime					)(LONG *year, LONG *month, LONG *day, LONG *hour, LONG *minute, LONG *second);
	LONG						(*GetTimer						)(void);
	void						(*GetLineEnd					)(String *str);
	LONG						(*GetDefaultFPS				)(void);
	LONG						(*OutString						)(const String *str, LONG flags);
	LONG						(*GetCurrentOS				)(void);
	LONG						(*GetByteOrder				)(void);
	void						(*GetGray							)(LONG *r, LONG *g, LONG *b);
	Bool						(*ChooseColor					)(Vector *col);
	void						(*GetSerialInfoEx			)(String *s1, String *s2, String *s3, String *s4, String *s5, String *s6);
	Bool						(*RegisterPluginEx		)(LONG api_version, LONG type, LONG id,String *str,void *data);
	void						(*GetNewMarkerEx			)(ULONG *l1, ULONG *l2);
	void						(*SetMousePointer			)(LONG l);
	Bool						(*ShowBitmap1					)(const Filename *fn);
	Bool						(*ShowBitmap2					)(BaseBitmap *bm);
	void						(*StopAllThreads			)(void);
	void						(*StatusClear					)(void);
	void						(*StatusSetSpin				)(void);
	void						(*StatusSetBar				)(LONG p);
	void						(*StatusSetText				)(const String *str);
	void						(*SpecialEventAdd			)(LONG type, ULONG p1, ULONG p2);
	Bool						(*DrawViews						)(LONG flags);
	void*						(*SendModelingCommandEx)(LONG command, BaseDocument *doc, BaseObject *op, const BaseContainer *bc, LONG mode);
	void						(*GetGlobalTexturePath)(LONG i, Filename *fn);
	void						(*SetGlobalTexturePath)(LONG i, const Filename *fn);
	Bool						(*GenerateTexturePathEx)(const Filename *docpath, const Filename *srcname, Filename *dstname);
	void						(*FlushTextureEx			)(const String *name);
	void						(*FlushUnusedTextures	)(void);
	void						(*GetWorldContainer		)(BaseContainer *bc);
	void						(*ErrorStringDialog   )(LONG type, Real x, Real y, LONG is);

	void						(*lSwap								)(void *adr, LONG cnt);
	void						(*wSwap								)(void *adr, LONG cnt);
	void						(*lIntel							)(void *adr, LONG cnt);
	void						(*wIntel							)(void *adr, LONG cnt);
	void						(*lMotor							)(void *adr, LONG cnt);
	void						(*wMotor							)(void *adr, LONG cnt);

	void						(*InsertBaseDocument	)(BaseDocument *doc);
	void						(*SetActiveDocument		)(BaseDocument *doc);
	BaseDocument*		(*GetActiveDocument		)(void);
	BaseDocument*		(*GetFirstDocument		)(void);
	void						(*KillDocument				)(BaseDocument *doc);
	Bool						(*LoadFile						)(const Filename *name);
	Bool						(*LoadDocument				)(BaseDocument *doc, const Filename *name, Bool show_error);
	Bool						(*SaveDocument				)(BaseDocument *doc, const Filename *name, Bool show_error, LONG format);
	LONG						(*RenderDocument			)(BaseDocument *doc, ProgressHook *pr, void *private_data, BaseBitmap *bmp, const BaseContainer *rdata, LONG renderflags, Bool dummy, BaseThread *th, LONG v_left, LONG v_top, LONG v_right, LONG v_bottom);
	Vector					(*GetColor						)(LONG i);
	Bool						(*RegisterPlugin			)(LONG api_version, LONG type, LONG id, const String *str,void *data,LONG datasize);
	void						(*GetSerialInfo				)(LONG type, String *s1, String *s2, String *s3, String *s4, String *s5, String *s6);
	LONG						(*GetVersionType			)(void);
	void						(*FlushTexture				)(const Filename *docpath, const String *name);
	Bool						(*ReadPluginInfo			)(LONG pluginid, CHAR *buffer, LONG size);
	Bool						(*WritePluginInfo			)(LONG pluginid, CHAR *buffer, LONG size);

	void						(*EwDrawXORLine				)(EditorWindow *win, LONG x1,LONG y1,LONG x2,LONG y2);
	void						(*EwMouseDragStart		)(EditorWindow *win, LONG button,Real mx,Real my,LONG flag);
	LONG						(*EwMouseDrag					)(EditorWindow *win, Real *mx,Real *my,BaseContainer *channels);
	LONG						(*EwMouseDragEnd			)(EditorWindow *win);
	Bool						(*EwBfGetInputState		)(EditorWindow *win, LONG askdevice,LONG askchannel,BaseContainer *res);
	Bool						(*EwBfGetInputEvent		)(EditorWindow *win, LONG askdevice,BaseContainer *res);

	Bool						(*GetMovieInfo				)(const Filename *name, LONG *frames, LONG *fps);
	LONG						(*ShowPopupMenu       )(CDialog *parent,LONG screenx,LONG screeny,const BaseContainer *bc,LONG flags);

	Bool						(*RegistryAdd         )(LONG sub_id, LONG main_id, void *data);
	Bool						(*RegistryRemove      )(LONG sub_id, LONG main_id);
	Registry*				(*RegistryFind				)(LONG sub_id, LONG main_id);
	Registry*				(*RegistryFindLast		)(LONG main_id);
	Registry*				(*RegistryFindFirst		)(LONG main_id);
	Registry*				(*RegistryFindPrev		)(Registry *last);
	Registry*				(*RegistryFindNext		)(Registry *last);
	Bool						(*RegistryGetAutoID		)(LONG *id);
	Bool						(*RegistryGetData			)(Registry *reg, LONG *main_id, LONG *sub_id, void **data);

	void*						(*Alloc								)(LONG size,LONG line,const CHAR *file);
	void						(*Boom								)(void);
	BaseContainer*	(*GetWorldPluginData  )(LONG id);
	Bool						(*SetWorldPluginData  )(LONG id, const BaseContainer *bc, Bool add);
	Bool            (*SyncMessage         )(LONG message, LONG core_id, LONG par1, LONG par2);
	void						(*SetWorldContainer		)(const BaseContainer *bc);
	Bool						(*PluginMessage				)(LONG id, void *data);

	BasePlugin*			(*FindPlugin										)(LONG id, LONG type);
	BasePlugin*			(*GetFirstPlugin								)(void);
	void*						(BasePlugin::*GetPluginStructure)();
	Filename				(BasePlugin::*GetFilename				)(void);
	LONG						(BasePlugin::*GetID							)(void);
	LONG						(BasePlugin::*GetInfo						)(void);

	Bool						(*ChooseFont					)(BaseContainer *col);

	void						(*GeDebugBreak				)(LONG line, const CHAR *file);
	void						(*GeDebugOut					)(const CHAR* s,...);
	Bool						(*RenameDialog				)(String *str);
	Bool						(*OpenHTML						)(const String &webaddress);
	Bool						(*SendModelingCommand )(LONG command, ModelingCommandData &data);

	void						(*EventAdd						)(LONG flags);
	void						(*FindInManager				)(BaseList2D *bl);

	CUSTOMDATATYPEPLUGIN*		(*FindCustomDataTypePlugin		)(LONG type);
	RESOURCEDATATYPEPLUGIN*	(*FindResourceDataTypePlugin	)(LONG type);

	void						(*GeSleep							)(LONG milliseconds);
	GeData					(*SendCoreMessage			)(LONG coreid, const BaseContainer &msg, LONG eventid);
	Bool						(*CheckIsRunning			)(LONG type);
	BaseContainer*	(*GetWorldContainerInstance)(void);

	Bool						(*GenerateTexturePath )(const Filename &docpath, const Filename &srcname, const Filename &suggestedpath, Filename *dstname);
	Bool						(*IsInSearchPath			)(const Filename &texfilename, const Filename &docpath);
};

struct C4D_Link
{
	BaseLink*				(*Alloc								)(void);
	void						(*Free								)(BaseLink *link);
	BaseList2D*			(*GetLink							)(BaseLink *link, BaseDocument *doc, LONG instanceof);
	void						(*SetLink							)(BaseLink *link, BaseList2D *list);
	Bool						(*Read								)(BaseLink *link, HyperFile *hf);
	Bool						(*Write								)(BaseLink *link, HyperFile *hf);
	BaseLink*				(*GetClone						)(BaseLink *link, LONG flags, AliasTrans *trn);
	Bool						(*CopyTo							)(BaseLink *src, BaseLink *dst, LONG flags, AliasTrans *trn);
	AliasTrans*			(*TrnAlloc						)(void);
	Bool						(*TrnInit							)(AliasTrans *trn, BaseDocument *doc);
	void						(*TrnFree							)(AliasTrans *trn);
	void						(*TrnTranslate				)(AliasTrans *trn, Bool connect_oldgoals);	
	BaseList2D*			(*ForceGetLink				)(BaseLink *link);
};

struct C4D_Neighbor
{
	EnumerateEdges*	(*Alloc								)(LONG pcnt, Polygon *vadr, LONG vcnt, BaseSelect *bs);
	void						(*Free								)(EnumerateEdges *nb);
	void						(*GetEdgePolys				)(EnumerateEdges *nb, LONG a, LONG b,LONG *first,LONG *second);
	void						(*GetPointPolys				)(EnumerateEdges *nb, LONG pnt, LONG **dadr, LONG *dcnt);
	LONG						(*GetEdgeCount				)(EnumerateEdges *nb);
	PolyInfo*				(*GetPolyInfo					)(EnumerateEdges *nb, LONG poly);
};

struct C4D_Painter
{
	void*						(*SendPainterCommand  )(LONG command, BaseDocument *doc, PaintTexture *tex, const BaseContainer *bc);
	Bool						(*OptimalMappingEx		)(PMStruct *pm_adr, Polygon *vadr, LONG vcnt, Vector *padr, LONG pcnt, Bool progressbar, const BaseContainer *bc);

	// new in BP2
	Bool						(*CallUVCommand				)(Vector *padr, LONG PointCount, Polygon *polys, LONG lPolyCount, UVWStruct *uvw, BaseSelect *polyselection,
                                            BaseSelect* pointselection, BaseObject*op, LONG mode, LONG cmdid, const BaseContainer &settings);

	TempUVHandle*		(*GetActiveUVSet			)(BaseDocument* doc, LONG flags);
	void						(*FreeActiveUVSet			)(TempUVHandle *handle);

	LONG						(*UVSetGetMode				)(TempUVHandle *handle);
	Vector*					(*UVSetGetPoint				)(TempUVHandle *handle);
	LONG						(*UVSetGetPointCount	)(TempUVHandle *handle);
	Polygon*				(*UVSetGetPoly				)(TempUVHandle *handle);
	LONG						(*UVSetGetPolyCount		)(TempUVHandle *handle);
	UVWStruct*			(*UVSetGetUVW					)(TempUVHandle *handle);
	BaseSelect*			(*UVSetGetPolySel			)(TempUVHandle *handle);
	BaseSelect*			(*UVSetGetPointSel		)(TempUVHandle *handle);
	BaseObject*			(*UVSetGetBaseObject	)(TempUVHandle *handle);

	Bool						(*UVSetSetUVW					)(TempUVHandle *handle, UVWStruct *uv);

	Bool						(*Private1						)(LONG lCommand, AtomArray* pArray, BaseSelect **polyselection,BaseContainer& setttings);

	PaintTexture*		(*CreateNewTexture		)(const Filename &path, const BaseContainer &settings);
	Bool						(*GetTextureDefaults	)(LONG channel,BaseContainer &settings);

	Bool						(*UVSetIsEditable			)(TempUVHandle *handle);

	LONG						(*IdentifyImage				)(const Filename &texpath);
};

#define C4D_RADIOSITY_ID	1000969
#define C4D_CAUSTICS_ID		1000970

struct SSSData
{
	Vector	color;
	LONG		samples;
	Bool		multiscatter;
	Real		density,minthickness,strength;
};

struct C4D_Radiosity
{
	LONG disklevel,custom_id;

	Vector					(*ComputeDiffuseIllumination)(VideoPostData *data, VolumeData *vd, Real receive_strength, Real accuracy);
	Bool						(*LoadGI										)(VideoPostData *data, BaseFile *file, LONG disklevel);
	Bool						(*SaveGI										)(VideoPostData *data, BaseFile *file);
	void						(*FlushGI										)(VideoPostData *data);

	Vector					(*ComputeSSS							  )(VolumeData *vd, SSSData *dat);
};

struct C4D_Caustics
{
	LONG disklevel,custom_id;

	Vector					(*ComputeSurfaceCaustic 		)(VideoPostData *data, VolumeData *vd, Real sampleradius, LONG accuracy);
	Vector					(*ComputeVolumeCaustic 			)(VideoPostData *data, const Vector &p);
	Bool						(*LoadCS										)(VideoPostData *data, BaseFile *file, LONG disklevel);
	Bool						(*SaveCS										)(VideoPostData *data, BaseFile *file);
	void						(*FlushCS										)(VideoPostData *data);
};

struct OperatingSystem
{
	LONG version;

	C4D_General				*Ge;
	C4D_Shader				*Sh;
	C4D_HyperFile			*Hf;
	C4D_BaseContainer *Bc;
	C4D_String				*St;
	C4D_Bitmap				*Bm;
	C4D_MovieSaver		*Ms;
	C4D_BaseChannel		*Ba;
	C4D_Filename			*Fn;
	C4D_File					*Fl;
	C4D_BrowseFiles		*Bf;
	C4D_Dialog				*Cd;
	C4D_UserArea			*Cu;
	C4D_Parser				*Pr;
	C4D_Resource			*Lr;
	C4D_BaseList			*Bl;
	C4D_Tag						*Tg;
	C4D_Object				*Bo;
	C4D_Document			*Bd;
	C4D_Thread				*Bt;
	C4D_Material			*Mt;
	C4D_Texture				*Tx;
	C4D_BaseSelect		*Bs;
	C4D_Key						*Bk;
	C4D_Sequence			*Bq;
	C4D_Track					*Be;
	C4D_BaseSound			*Bu;
	C4D_BaseDraw			*Br;
	C4D_BaseView			*Bv;
	C4D_Neighbor			*Nb;
	C4D_Pool					*Pl;
	C4D_BitmapFilter	*Fi;
	C4D_Painter				*Pa;
	C4D_Radiosity			*Ra;
	C4D_Caustics			*Cs;
	C4D_Link					*Ln;
	C4D_GraphView			*Gv;
	C4D_GeData				*Gd;
	C4D_Atom					*At;
	C4D_Coffee				*Co;
};

#ifndef __API_INTERN__
	#define C4DOS (*t_C4DOS)
#endif

extern OperatingSystem C4DOS;

#endif
